/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlDropMapping
extends SqlDrop {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP EXTERNAL MAPPING", SqlKind.DROP_TABLE);
    private final SqlIdentifier name;

    public SqlDropMapping(SqlIdentifier name, boolean ifExists, SqlParserPos pos) {
        super(OPERATOR, pos, ifExists);
        this.name = Objects.requireNonNull(name, "Name should not be null");
    }

    public String nameWithoutSchema() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP EXTERNAL MAPPING");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (!ValidationUtil.isCatalogObjectNameValid(this.name)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.droppedMappingDoesNotExist(this.name.toString()));
        }
    }
}

