/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class UnparseUtil {
    private UnparseUtil() {
    }

    @Nullable
    public static SqlIdentifier identifier(String ... names) {
        if (names == null || names.length == 1 && names[0] == null) {
            return null;
        }
        return new SqlIdentifier(Arrays.asList(names), SqlParserPos.ZERO);
    }

    public static void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public static void unparseOptions(SqlWriter writer, SqlNodeList options) {
        if (options != null && options.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("OPTIONS");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : options) {
                UnparseUtil.printIndent(writer);
                property.unparse(writer, 0, 0);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    public static SqlNodeList reconstructOptions(Map<String, String> options) {
        return UnparseUtil.nodeList(options.entrySet(), o -> new SqlOption(SqlLiteral.createCharString((String)o.getKey(), SqlParserPos.ZERO), SqlLiteral.createCharString((String)o.getValue(), SqlParserPos.ZERO), SqlParserPos.ZERO));
    }

    public static <T> SqlNodeList nodeList(Collection<T> collection, Function<T, SqlNode> mapFn) {
        return new SqlNodeList(Util.toList(collection, mapFn), SqlParserPos.ZERO);
    }
}

