/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import javax.annotation.Nonnull;

public class LateItemsDropP
extends AbstractProcessor {
    @Probe(name="lateEventsDropped")
    private final Counter lateEventsDropped = SwCounter.newSwCounter();
    private final byte watermarkKey;
    private final Expression<?> timestampExpression;
    private ExpressionEvalContext evalContext;
    private long currentWm = Long.MIN_VALUE;

    public LateItemsDropP(byte watermarkKey, Expression<?> timestampExpression) {
        this.watermarkKey = watermarkKey;
        this.timestampExpression = timestampExpression;
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
        super.init(context);
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        Row row = ((JetSqlRow)item).getRow();
        long timestamp = WindowUtils.extractMillis(this.timestampExpression.eval(row, this.evalContext));
        if (timestamp < this.currentWm) {
            Util.logLateEvent((ILogger)this.getLogger(), (byte)0, (long)this.currentWm, (Object)item);
            this.lateEventsDropped.inc();
            return true;
        }
        return this.tryEmit(item);
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        if (watermark.key() == this.watermarkKey) {
            this.currentWm = watermark.timestamp();
        }
        return super.tryProcessWatermark(watermark);
    }

    public boolean isCooperative() {
        return this.timestampExpression.isCooperative();
    }

    public boolean closeIsCooperative() {
        return true;
    }
}

