/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.string;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.OperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastSubstringFunction
extends HazelcastFunction {
    public static final HazelcastSubstringFunction INSTANCE = new HazelcastSubstringFunction();

    private HazelcastSubstringFunction() {
        super("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, new ReplaceUnknownOperandTypeInference(new SqlTypeName[]{SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.INTEGER}), SqlFunctionCategory.STRING);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} FROM {2})";
            }
            case 3: {
                return "{0}({1} FROM {2} FOR {3})";
            }
        }
        throw new AssertionError();
    }

    @Override
    public String getAllowedSignatures(String opName) {
        StringBuilder ret = new StringBuilder();
        for (Ord<SqlTypeName> typeName : Ord.zip(SqlTypeName.CHAR_TYPES)) {
            if (typeName.i > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of(typeName.e, SqlTypeName.INTEGER)));
            ret.append(NL);
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of(typeName.e, SqlTypeName.INTEGER, SqlTypeName.INTEGER)));
        }
        return ret.toString();
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding binding, boolean throwOnFailure) {
        if (binding.getOperandCount() == 2) {
            return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.INTEGER).check(binding, throwOnFailure);
        }
        assert (binding.getOperandCount() == 3);
        return new OperandCheckerProgram(TypedOperandChecker.VARCHAR, TypedOperandChecker.INTEGER, TypedOperandChecker.INTEGER).check(binding, throwOnFailure);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        if (call.operandCount() == 3) {
            writer.sep("FOR");
            ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }
}

