/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectTypeReference;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.HashMap;
import java.util.Map;

public final class HazelcastTypeUtils {
    private static final Map<SqlTypeName, QueryDataType> CALCITE_TO_HZ = new HashMap<SqlTypeName, QueryDataType>();
    private static final Map<QueryDataTypeFamily, SqlTypeName> HZ_TO_CALCITE = new HashMap<QueryDataTypeFamily, SqlTypeName>();

    private HazelcastTypeUtils() {
    }

    public static SqlTypeName toCalciteType(QueryDataType type) {
        return HazelcastTypeUtils.toCalciteType(type.getTypeFamily());
    }

    public static SqlTypeName toCalciteType(QueryDataTypeFamily typeFamily) {
        return HZ_TO_CALCITE.get((Object)typeFamily);
    }

    public static QueryDataType toHazelcastType(RelDataType relDataType) {
        if (relDataType.getSqlTypeName() != SqlTypeName.OTHER) {
            return HazelcastTypeUtils.toHazelcastTypeFromSqlTypeName(relDataType.getSqlTypeName());
        }
        RelDataTypeFamily typeFamily = relDataType.getFamily();
        if (typeFamily instanceof HazelcastJsonType) {
            return QueryDataType.JSON;
        }
        if (typeFamily instanceof HazelcastObjectType) {
            return HazelcastTypeUtils.convertHazelcastObjectType(relDataType);
        }
        throw new IllegalArgumentException("Unexpected SQL type: " + relDataType);
    }

    private static QueryDataType convertHazelcastObjectType(RelDataType relDataType) {
        HazelcastObjectType hazelcastObjectType = HazelcastTypeUtils.extractHzObjectType(relDataType);
        HashMap<String, QueryDataType> typeMap = new HashMap<String, QueryDataType>();
        HazelcastTypeUtils.traverseHzObjectType(hazelcastObjectType, typeMap);
        return (QueryDataType)typeMap.get(hazelcastObjectType.getTypeName());
    }

    private static void traverseHzObjectType(HazelcastObjectType source, Map<String, QueryDataType> discovered) {
        if (discovered.containsKey(source.getTypeName())) {
            return;
        }
        QueryDataType current = new QueryDataType(source.getTypeName());
        discovered.put(current.getObjectTypeName(), current);
        for (RelDataTypeField field : source.getFieldList()) {
            QueryDataType fieldType;
            if (field.getType() instanceof HazelcastObjectType || field.getType() instanceof HazelcastObjectTypeReference) {
                HazelcastObjectType fieldRelDataType = HazelcastTypeUtils.extractHzObjectType(field.getType());
                if (!discovered.containsKey(fieldRelDataType.getTypeName())) {
                    HazelcastTypeUtils.traverseHzObjectType(fieldRelDataType, discovered);
                }
                fieldType = discovered.get(fieldRelDataType.getTypeName());
            } else {
                fieldType = HazelcastTypeUtils.toHazelcastType(field.getType());
            }
            current.getObjectFields().add(field.getIndex(), new QueryDataType.QueryDataTypeField(field.getName(), fieldType));
        }
    }

    public static QueryDataType toHazelcastTypeFromSqlTypeName(SqlTypeName sqlTypeName) {
        SqlTypeFamily sqlTypeNameFamily = sqlTypeName.getFamily();
        if (sqlTypeNameFamily == SqlTypeFamily.INTERVAL_YEAR_MONTH) {
            return QueryDataType.INTERVAL_YEAR_MONTH;
        }
        if (sqlTypeNameFamily == SqlTypeFamily.INTERVAL_DAY_TIME) {
            return QueryDataType.INTERVAL_DAY_SECOND;
        }
        QueryDataType queryDataType = CALCITE_TO_HZ.get((Object)sqlTypeName);
        if (queryDataType == null) {
            throw new IllegalArgumentException("Unexpected SQL type: " + (Object)((Object)sqlTypeName));
        }
        return queryDataType;
    }

    public static RelDataType createType(RelDataTypeFactory typeFactory, SqlTypeName typeName, boolean nullable) {
        RelDataType type = typeFactory.createSqlType(typeName);
        if (nullable) {
            type = HazelcastTypeUtils.createNullableType(typeFactory, type);
        }
        return type;
    }

    public static RelDataType createNullableType(RelDataTypeFactory typeFactory, RelDataType type) {
        if (!type.isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    public static boolean isObjectIdentifier(SqlIdentifier identifier) {
        return identifier.isSimple() && StringUtil.equalsIgnoreCase((String)SqlColumnType.OBJECT.name(), (String)identifier.getSimple());
    }

    public static boolean isJsonIdentifier(SqlIdentifier identifier) {
        return identifier.isSimple() && StringUtil.equalsIgnoreCase((String)SqlColumnType.JSON.name(), (String)identifier.getSimple());
    }

    public static boolean isJsonType(RelDataType type) {
        return SqlTypeName.OTHER.equals((Object)type.getSqlTypeName()) && HazelcastJsonType.FAMILY.equals(type.getFamily());
    }

    public static boolean isHzObjectType(RelDataType type) {
        return type instanceof HazelcastObjectType || type instanceof HazelcastObjectTypeReference;
    }

    public static HazelcastObjectType extractHzObjectType(RelDataType relDataType) {
        return relDataType instanceof HazelcastObjectTypeReference ? (HazelcastObjectType)((HazelcastObjectTypeReference)relDataType).getOriginal() : (HazelcastObjectType)relDataType;
    }

    public static boolean isNumericType(RelDataType type) {
        return HazelcastTypeUtils.isNumericType(type.getSqlTypeName());
    }

    public static boolean isNumericType(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericIntegerType(RelDataType type) {
        return HazelcastTypeUtils.isNumericIntegerType(type.getSqlTypeName());
    }

    public static boolean isNumericIntegerType(SqlTypeName typeName) {
        switch (typeName) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericInexactType(RelDataType type) {
        return HazelcastTypeUtils.isNumericInexactType(type.getSqlTypeName());
    }

    public static boolean isNumericInexactType(SqlTypeName typeName) {
        switch (typeName) {
            case FLOAT: 
            case REAL: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTemporalType(RelDataType type) {
        return HazelcastTypeUtils.isTemporalType(type.getSqlTypeName());
    }

    public static boolean isTemporalType(SqlTypeName typeName) {
        switch (typeName) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntervalType(RelDataType type) {
        return HazelcastTypeUtils.isIntervalType(type.getSqlTypeName());
    }

    public static boolean isIntervalType(SqlTypeName typeName) {
        SqlTypeFamily typeFamily = typeName.getFamily();
        return typeFamily == SqlTypeFamily.INTERVAL_DAY_TIME || typeFamily == SqlTypeFamily.INTERVAL_YEAR_MONTH;
    }

    public static boolean isNullOrUnknown(SqlTypeName typeName) {
        return typeName == SqlTypeName.NULL || typeName == SqlTypeName.UNKNOWN;
    }

    public static RelDataType withHigherPrecedence(RelDataType type1, RelDataType type2) {
        int precedence1 = HazelcastTypeUtils.precedenceOf(type1);
        int precedence2 = HazelcastTypeUtils.precedenceOf(type2);
        assert (precedence1 != precedence2 || type1.getSqlTypeName() == type2.getSqlTypeName() || type1.getSqlTypeName() == SqlTypeName.NULL && type2.getSqlTypeName() == SqlTypeName.UNKNOWN || type1.getSqlTypeName() == SqlTypeName.UNKNOWN && type2.getSqlTypeName() == SqlTypeName.NULL);
        if (precedence1 == precedence2 && HazelcastTypeUtils.isNumericIntegerType(type1) && HazelcastTypeUtils.isNumericIntegerType(type2)) {
            int bitWidth2;
            int bitWidth1 = ((HazelcastIntegerType)type1).getBitWidth();
            return bitWidth1 > (bitWidth2 = ((HazelcastIntegerType)type2).getBitWidth()) ? type1 : type2;
        }
        return precedence1 > precedence2 ? type1 : type2;
    }

    public static int precedenceOf(RelDataType type) {
        return HazelcastTypeUtils.toHazelcastType(type).getTypeFamily().getPrecedence();
    }

    public static boolean canCast(RelDataType sourceType, RelDataType targetType) {
        if (targetType.equals(sourceType)) {
            return true;
        }
        QueryDataType queryFrom = HazelcastTypeUtils.toHazelcastType(sourceType);
        QueryDataType queryTo = HazelcastTypeUtils.toHazelcastType(targetType);
        if (HazelcastTypeUtils.isStruct(sourceType) || HazelcastTypeUtils.isStruct(targetType)) {
            if (queryFrom.isCustomType() && queryTo.getTypeFamily().equals((Object)QueryDataTypeFamily.JSON)) {
                return true;
            }
            if (!HazelcastTypeUtils.isStruct(sourceType) || !HazelcastTypeUtils.isStruct(targetType)) {
                return false;
            }
            if (sourceType.getSqlTypeName() != targetType.getSqlTypeName() && !targetType.getSqlTypeName().equals((Object)SqlTypeName.ROW) && !sourceType.getSqlTypeName().equals((Object)SqlTypeName.ROW)) {
                return false;
            }
            int n = targetType.getFieldCount();
            if (sourceType.getFieldCount() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                RelDataTypeField toField = targetType.getFieldList().get(i);
                RelDataTypeField fromField = sourceType.getFieldList().get(i);
                if (HazelcastTypeUtils.canCast(toField.getType(), fromField.getType())) continue;
                return false;
            }
            return true;
        }
        return queryFrom.getConverter().canConvertTo(queryTo.getTypeFamily());
    }

    private static boolean isStruct(RelDataType relDataType) {
        return relDataType.isStruct() && relDataType.getFieldCount() > 0;
    }

    public static boolean hasParameters(SqlCallBinding binding) {
        return binding.operands().stream().anyMatch(operand -> operand.getKind() == SqlKind.DYNAMIC_PARAM);
    }

    public static boolean hasSameTypeFamily(RelDataType sourceType, RelDataType targetType) {
        return sourceType.getFamily().equals(targetType.getFamily());
    }

    static {
        HZ_TO_CALCITE.put(QueryDataTypeFamily.VARCHAR, SqlTypeName.VARCHAR);
        CALCITE_TO_HZ.put(SqlTypeName.VARCHAR, QueryDataType.VARCHAR);
        CALCITE_TO_HZ.put(SqlTypeName.CHAR, QueryDataType.VARCHAR);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.BOOLEAN, SqlTypeName.BOOLEAN);
        CALCITE_TO_HZ.put(SqlTypeName.BOOLEAN, QueryDataType.BOOLEAN);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TINYINT, SqlTypeName.TINYINT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.SMALLINT, SqlTypeName.SMALLINT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.INTEGER, SqlTypeName.INTEGER);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.BIGINT, SqlTypeName.BIGINT);
        CALCITE_TO_HZ.put(SqlTypeName.TINYINT, QueryDataType.TINYINT);
        CALCITE_TO_HZ.put(SqlTypeName.SMALLINT, QueryDataType.SMALLINT);
        CALCITE_TO_HZ.put(SqlTypeName.INTEGER, QueryDataType.INT);
        CALCITE_TO_HZ.put(SqlTypeName.BIGINT, QueryDataType.BIGINT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.DECIMAL, SqlTypeName.DECIMAL);
        CALCITE_TO_HZ.put(SqlTypeName.DECIMAL, QueryDataType.DECIMAL);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.REAL, SqlTypeName.REAL);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.DOUBLE, SqlTypeName.DOUBLE);
        CALCITE_TO_HZ.put(SqlTypeName.REAL, QueryDataType.REAL);
        CALCITE_TO_HZ.put(SqlTypeName.DOUBLE, QueryDataType.DOUBLE);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TIME, SqlTypeName.TIME);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.DATE, SqlTypeName.DATE);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TIMESTAMP, SqlTypeName.TIMESTAMP);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        CALCITE_TO_HZ.put(SqlTypeName.TIME, QueryDataType.TIME);
        CALCITE_TO_HZ.put(SqlTypeName.DATE, QueryDataType.DATE);
        CALCITE_TO_HZ.put(SqlTypeName.TIMESTAMP, QueryDataType.TIMESTAMP);
        CALCITE_TO_HZ.put(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE, QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.OBJECT, SqlTypeName.ANY);
        CALCITE_TO_HZ.put(SqlTypeName.ANY, QueryDataType.OBJECT);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.NULL, SqlTypeName.NULL);
        CALCITE_TO_HZ.put(SqlTypeName.NULL, QueryDataType.NULL);
        CALCITE_TO_HZ.put(SqlTypeName.UNKNOWN, QueryDataType.NULL);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.INTERVAL_YEAR_MONTH, SqlTypeName.INTERVAL_YEAR_MONTH);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.INTERVAL_DAY_SECOND, SqlTypeName.INTERVAL_DAY_SECOND);
        CALCITE_TO_HZ.put(SqlTypeName.MAP, QueryDataType.MAP);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.JSON, SqlTypeName.OTHER);
        HZ_TO_CALCITE.put(QueryDataTypeFamily.ROW, SqlTypeName.ROW);
        CALCITE_TO_HZ.put(SqlTypeName.ROW, QueryDataType.ROW);
    }
}

