/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Project;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMdCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class EnumerableProject
extends Project
implements EnumerableRel {
    public EnumerableProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, ImmutableList.of(), input, projects, rowType);
        assert (this.getConvention() instanceof EnumerableConvention);
    }

    @Deprecated
    public EnumerableProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, input, projects, rowType);
        Util.discard(flags);
    }

    public static EnumerableProject create(RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.project(mq, input, projects));
        return new EnumerableProject(cluster, traitSet, input, projects, rowType);
    }

    @Override
    public EnumerableProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new EnumerableProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        return EnumerableTraitsUtils.passThroughTraitsForProject(required, this.exps, this.input.getRowType(), this.input.getCluster().getTypeFactory(), this.traitSet);
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        return EnumerableTraitsUtils.deriveTraitsForProject(childTraits, childId, this.exps, this.input.getRowType(), this.input.getCluster().getTypeFactory(), this.traitSet);
    }
}

