/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.jdbc;

import com.hazelcast.shaded.com.google.common.base.Suppliers;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.adapter.java.AbstractQueryableTable;
import com.hazelcast.shaded.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.adapter.jdbc.JdbcSchema;
import com.hazelcast.shaded.org.apache.calcite.adapter.jdbc.JdbcTableScan;
import com.hazelcast.shaded.org.apache.calcite.adapter.jdbc.JdbcUtils;
import com.hazelcast.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteConnection;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.QueryProvider;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Queryable;
import com.hazelcast.shaded.org.apache.calcite.plan.Convention;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTrait;
import com.hazelcast.shaded.org.apache.calcite.prepare.Prepare;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelProtoDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.runtime.ResultSetEnumerable;
import com.hazelcast.shaded.org.apache.calcite.schema.ModifiableTable;
import com.hazelcast.shaded.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.shaded.org.apache.calcite.schema.Schema;
import com.hazelcast.shaded.org.apache.calcite.schema.SchemaPlus;
import com.hazelcast.shaded.org.apache.calcite.schema.TranslatableTable;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.AbstractTableQueryable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriterConfig;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlString;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class JdbcTable
extends AbstractQueryableTable
implements TranslatableTable,
ScannableTable,
ModifiableTable {
    private final Supplier<RelProtoDataType> protoRowTypeSupplier = Suppliers.memoize(this::supplyProto)::get;
    public final JdbcSchema jdbcSchema;
    public final String jdbcCatalogName;
    public final String jdbcSchemaName;
    public final String jdbcTableName;
    public final Schema.TableType jdbcTableType;

    JdbcTable(JdbcSchema jdbcSchema, String jdbcCatalogName, String jdbcSchemaName, String jdbcTableName, Schema.TableType jdbcTableType) {
        super((Type)((Object)Object[].class));
        this.jdbcSchema = Objects.requireNonNull(jdbcSchema, "jdbcSchema");
        this.jdbcCatalogName = jdbcCatalogName;
        this.jdbcSchemaName = jdbcSchemaName;
        this.jdbcTableName = Objects.requireNonNull(jdbcTableName, "jdbcTableName");
        this.jdbcTableType = Objects.requireNonNull(jdbcTableType, "jdbcTableType");
    }

    public String toString() {
        return "JdbcTable {" + this.jdbcTableName + "}";
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return this.jdbcTableType;
    }

    @Override
    public <C> @Nullable C unwrap(Class<C> aClass) {
        if (aClass.isInstance(this.jdbcSchema.getDataSource())) {
            return aClass.cast(this.jdbcSchema.getDataSource());
        }
        if (aClass.isInstance(this.jdbcSchema.dialect)) {
            return aClass.cast(this.jdbcSchema.dialect);
        }
        return super.unwrap(aClass);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowTypeSupplier.get().apply(typeFactory);
    }

    private RelProtoDataType supplyProto() {
        try {
            return this.jdbcSchema.getRelDataType(this.jdbcCatalogName, this.jdbcSchemaName, this.jdbcTableName);
        }
        catch (SQLException e) {
            throw new RuntimeException("Exception while reading definition of table '" + this.jdbcTableName + "'", e);
        }
    }

    private List<Pair<ColumnMetaData.Rep, Integer>> fieldClasses(JavaTypeFactory typeFactory) {
        RelDataType rowType = this.getRowType(typeFactory);
        return Util.transform(rowType.getFieldList(), f -> {
            RelDataType type = f.getType();
            Class clazz = (Class)typeFactory.getJavaClass(type);
            ColumnMetaData.Rep rep = Util.first(ColumnMetaData.Rep.of(clazz), ColumnMetaData.Rep.OBJECT);
            return Pair.of(rep, type.getSqlTypeName().getJdbcOrdinal());
        });
    }

    SqlString generateSql() {
        SqlNodeList selectList = SqlNodeList.SINGLETON_STAR;
        SqlSelect node = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, selectList, this.tableName(), null, null, null, null, null, null, null, null);
        SqlWriterConfig config = SqlPrettyWriter.config().withAlwaysUseParentheses(true).withDialect(this.jdbcSchema.dialect);
        SqlPrettyWriter writer = new SqlPrettyWriter(config);
        node.unparse(writer, 0, 0);
        return writer.toSqlString();
    }

    public SqlIdentifier tableName() {
        ArrayList<String> names = new ArrayList<String>(3);
        if (this.jdbcSchema.catalog != null) {
            names.add(this.jdbcSchema.catalog);
        }
        if (this.jdbcSchema.schema != null) {
            names.add(this.jdbcSchema.schema);
        }
        names.add(this.jdbcTableName);
        return new SqlIdentifier(names, SqlParserPos.ZERO);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new JdbcTableScan(context.getCluster(), context.getTableHints(), relOptTable, this, this.jdbcSchema.convention);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new JdbcTableQueryable(queryProvider, schema, tableName);
    }

    @Override
    public Enumerable<@Nullable Object[]> scan(DataContext root) {
        JavaTypeFactory typeFactory = root.getTypeFactory();
        SqlString sql = this.generateSql();
        return ResultSetEnumerable.of(this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.rowBuilderFactory2(this.fieldClasses(typeFactory)));
    }

    @Override
    public @Nullable Collection getModifiableCollection() {
        return null;
    }

    @Override
    public TableModify toModificationRel(RelOptCluster cluster, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, TableModify.Operation operation, @Nullable List<String> updateColumnList, @Nullable List<RexNode> sourceExpressionList, boolean flattened) {
        this.jdbcSchema.convention.register(cluster.getPlanner());
        return new LogicalTableModify(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), table, catalogReader, input, operation, updateColumnList, sourceExpressionList, flattened);
    }

    private class JdbcTableQueryable<T>
    extends AbstractTableQueryable<T> {
        JdbcTableQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            super(queryProvider, schema, JdbcTable.this, tableName);
        }

        public String toString() {
            return "JdbcTableQueryable {table: " + this.tableName + "}";
        }

        @Override
        public Enumerator<T> enumerator() {
            JavaTypeFactory typeFactory = ((CalciteConnection)this.queryProvider).getTypeFactory();
            SqlString sql = JdbcTable.this.generateSql();
            List pairs = JdbcTable.this.fieldClasses(typeFactory);
            ResultSetEnumerable enumerable = ResultSetEnumerable.of(JdbcTable.this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.rowBuilderFactory2(pairs));
            return enumerable.enumerator();
        }
    }
}

