/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.materialize;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.materialize.LatticeChildNode;
import com.hazelcast.shaded.org.apache.calcite.materialize.LatticeSpace;
import com.hazelcast.shaded.org.apache.calcite.materialize.LatticeTable;
import com.hazelcast.shaded.org.apache.calcite.materialize.MutableNode;
import com.hazelcast.shaded.org.apache.calcite.materialize.Path;
import com.hazelcast.shaded.org.apache.calcite.materialize.Step;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.IntPair;
import com.hazelcast.shaded.org.checkerframework.checker.initialization.qual.Initialized;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public abstract class LatticeNode {
    public final LatticeTable table;
    final int startCol;
    final int endCol;
    public final @Nullable String alias;
    private final ImmutableList<LatticeChildNode> children;
    public final String digest;

    LatticeNode(LatticeSpace space, @Nullable LatticeNode parent, MutableNode mutableNode) {
        this.table = Objects.requireNonNull(mutableNode.table);
        this.startCol = mutableNode.startCol;
        this.endCol = mutableNode.endCol;
        this.alias = mutableNode.alias;
        Preconditions.checkArgument(this.startCol >= 0);
        Preconditions.checkArgument(this.endCol > this.startCol);
        StringBuilder sb = new StringBuilder().append(space.simpleName(this.table));
        if (parent != null) {
            sb.append(':');
            int i = 0;
            for (IntPair p : Objects.requireNonNull(mutableNode.step, (String)"mutableNode.step").keys) {
                if (i++ > 0) {
                    sb.append(",");
                }
                sb.append(space.fieldName(parent.table, p.source));
            }
        }
        if (mutableNode.children.isEmpty()) {
            this.children = ImmutableList.of();
        } else {
            sb.append(" (");
            ImmutableList.Builder b = ImmutableList.builder();
            int i = 0;
            for (MutableNode mutableChild : mutableNode.children) {
                if (i++ > 0) {
                    sb.append(' ');
                }
                @Initialized LatticeChildNode node = new LatticeChildNode(space, this, mutableChild);
                sb.append(node.digest);
                b.add(node);
            }
            this.children = b.build();
            sb.append(")");
        }
        this.digest = sb.toString();
    }

    public String toString() {
        return this.digest;
    }

    public RelOptTable relOptTable() {
        return this.table.t;
    }

    abstract void use(List<LatticeNode> var1);

    void flattenTo(ImmutableList.Builder<LatticeNode> builder) {
        builder.add((Object)this);
        for (LatticeChildNode child : this.children) {
            child.flattenTo(builder);
        }
    }

    void createPathsRecurse(LatticeSpace space, List<Step> steps, List<Path> paths) {
        paths.add(space.addPath(steps));
        for (LatticeChildNode child : this.children) {
            steps.add(space.addEdge(this.table, child.table, child.link));
            child.createPathsRecurse(space, steps, paths);
            steps.remove(steps.size() - 1);
        }
    }
}

