/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.plan.volcano;

import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.VolcanoRuleCall;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import java.util.List;
import java.util.Map;

class VolcanoRuleMatch
extends VolcanoRuleCall {
    private String digest;

    VolcanoRuleMatch(VolcanoPlanner volcanoPlanner, RelOptRuleOperand operand0, RelNode[] rels, Map<RelNode, List<RelNode>> nodeInputs) {
        super(volcanoPlanner, operand0, (RelNode[])rels.clone(), nodeInputs);
        assert (VolcanoRuleMatch.allNotNull(rels, Litmus.THROW));
        this.digest = this.computeDigest();
    }

    public String toString() {
        return this.digest;
    }

    private String computeDigest() {
        StringBuilder buf = new StringBuilder("rule [" + this.getRule() + "] rels [");
        for (int i = 0; i < this.rels.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append('#').append(this.rels[i].getId());
        }
        buf.append(']');
        return buf.toString();
    }

    @Deprecated
    public void recomputeDigest() {
        this.digest = this.computeDigest();
    }

    private static <E> boolean allNotNull(E[] es, Litmus litmus) {
        for (E e : es) {
            if (e != null) continue;
            return litmus.fail("was null", new Object[]{es});
        }
        return litmus.succeed();
    }
}

