/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel;

import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.shaded.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class RelValidityChecker
extends RelVisitor
implements RelNode.Context {
    private int invalidCount;
    private final Deque<RelNode> stack = new ArrayDeque<RelNode>();

    @Override
    public Set<CorrelationId> correlationIds() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RelNode r : this.stack) {
            builder.addAll(r.getVariablesSet());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
        try {
            this.stack.push(node);
            if (!node.isValid(Litmus.THROW, this)) {
                ++this.invalidCount;
            }
            super.visit(node, ordinal, parent);
        }
        finally {
            this.stack.pop();
        }
    }

    public int invalidCount() {
        return this.invalidCount;
    }
}

