/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.core;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptSchema;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelInput;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelShuttle;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.Hintable;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class TableScan
extends AbstractRelNode
implements Hintable {
    protected final RelOptTable table;
    protected final ImmutableList<RelHint> hints;

    protected TableScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table) {
        super(cluster, traitSet);
        this.table = Objects.requireNonNull(table, "table");
        RelOptSchema relOptSchema = table.getRelOptSchema();
        if (relOptSchema != null) {
            cluster.getPlanner().registerSchema(relOptSchema);
        }
        this.hints = ImmutableList.copyOf(hints);
    }

    @Deprecated
    protected TableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        this(cluster, traitSet, ImmutableList.of(), table);
    }

    protected TableScan(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), ImmutableList.of(), input.getTable("table"));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.table.getRowCount();
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = this.table.getRowCount();
        double dCpu = dRows + 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.table.getRowType();
    }

    public static ImmutableIntList identity(RelOptTable table) {
        return ImmutableIntList.identity(table.getRowType().getFieldCount());
    }

    public ImmutableIntList identity() {
        return TableScan.identity(this.table);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName());
    }

    public RelNode project(ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields, RelBuilder relBuilder) {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldsUsed.equals(ImmutableBitSet.range(fieldCount)) && extraFields.isEmpty()) {
            return this;
        }
        int fieldSize = fieldsUsed.size() + extraFields.size();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>(fieldSize);
        ArrayList<String> nameList = new ArrayList<String>(fieldSize);
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        List<RelDataTypeField> fields = this.getRowType().getFieldList();
        Iterator<Object> iterator = fieldsUsed.iterator();
        while (iterator.hasNext()) {
            int i = iterator.next();
            RelDataTypeField field = fields.get(i);
            exprList.add(rexBuilder.makeInputRef(this, i));
            nameList.add(field.getName());
        }
        for (RelDataTypeField extraField : extraFields) {
            exprList.add(rexBuilder.makeNullLiteral(extraField.getType()));
            nameList.add(extraField.getName());
        }
        return relBuilder.push(this).project(exprList, nameList).build();
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public ImmutableList<RelHint> getHints() {
        return this.hints;
    }
}

