/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.externalize;

import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnitRange;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinConditionType;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplain;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainFormat;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInsertKeyword;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlMatchRecognize;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelectKeyword;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.NonNull;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public abstract class RelEnumTypes {
    private static final ImmutableMap<String, Enum<?>> ENUM_BY_NAME;

    private RelEnumTypes() {
    }

    private static void register(ImmutableMap.Builder<String, Enum<?>> builder, Class<? extends Enum> aClass) {
        for (Enum enumConstant : Nullness.castNonNull(aClass.getEnumConstants())) {
            builder.put(enumConstant.name(), enumConstant);
        }
    }

    public static @Nullable Object fromEnum(@Nullable Object value) {
        return value instanceof Enum ? RelEnumTypes.fromEnum((Enum)value) : value;
    }

    public static String fromEnum(Enum enumValue) {
        if (ENUM_BY_NAME.get(enumValue.name()) != enumValue) {
            throw new AssertionError((Object)("cannot serialize enum value to JSON: " + enumValue.getDeclaringClass().getCanonicalName() + "." + enumValue));
        }
        return enumValue.name();
    }

    static <E extends Enum<E>> @NonNull E toEnum(String name) {
        return (E)Objects.requireNonNull(ENUM_BY_NAME.get(name));
    }

    static {
        ImmutableMap.Builder<String, Enum<?>> enumByName = ImmutableMap.builder();
        RelEnumTypes.register(enumByName, JoinConditionType.class);
        RelEnumTypes.register(enumByName, JoinType.class);
        RelEnumTypes.register(enumByName, SqlExplain.Depth.class);
        RelEnumTypes.register(enumByName, SqlExplainFormat.class);
        RelEnumTypes.register(enumByName, SqlExplainLevel.class);
        RelEnumTypes.register(enumByName, SqlInsertKeyword.class);
        RelEnumTypes.register(enumByName, SqlJsonConstructorNullClause.class);
        RelEnumTypes.register(enumByName, SqlJsonQueryWrapperBehavior.class);
        RelEnumTypes.register(enumByName, SqlJsonValueEmptyOrErrorBehavior.class);
        RelEnumTypes.register(enumByName, SqlMatchRecognize.AfterOption.class);
        RelEnumTypes.register(enumByName, SqlSelectKeyword.class);
        RelEnumTypes.register(enumByName, SqlTrimFunction.Flag.class);
        RelEnumTypes.register(enumByName, TimeUnitRange.class);
        RelEnumTypes.register(enumByName, TableModify.Operation.class);
        ENUM_BY_NAME = enumByName.build();
    }
}

