/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.runtime;

import com.hazelcast.shaded.com.google.common.collect.Ordering;
import java.util.HashMap;
import java.util.List;

public interface SpaceFillingCurve2D {
    public long toIndex(double var1, double var3);

    public Point toPoint(long var1);

    public List<IndexRange> toRanges(double var1, double var3, double var5, double var7, RangeComputeHints var9);

    public static class Point {
        final double x;
        final double y;

        Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class IndexRanges {
        private IndexRanges() {
        }

        static IndexRange create(long l, long u, boolean contained) {
            return contained ? new CoveredRange(l, u) : new OverlappingRange(l, u);
        }
    }

    public static class IndexRangeOrdering
    extends Ordering<IndexRange> {
        @Override
        public int compare(IndexRange x, IndexRange y) {
            int c1 = Long.compare(x.lower(), y.lower());
            if (c1 != 0) {
                return c1;
            }
            return Long.compare(x.upper(), y.upper());
        }
    }

    public static class OverlappingRange
    extends AbstractRange {
        OverlappingRange(long lower, long upper) {
            super(lower, upper);
        }

        @Override
        public boolean contained() {
            return false;
        }

        public String toString() {
            return "overlap(" + this.lower + ", " + this.upper + ")";
        }
    }

    public static class CoveredRange
    extends AbstractRange {
        CoveredRange(long lower, long upper) {
            super(lower, upper);
        }

        @Override
        public boolean contained() {
            return true;
        }

        public String toString() {
            return "covered(" + this.lower + ", " + this.upper + ")";
        }
    }

    public static abstract class AbstractRange
    implements IndexRange {
        final long lower;
        final long upper;

        protected AbstractRange(long lower, long upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public long lower() {
            return this.lower;
        }

        @Override
        public long upper() {
            return this.upper;
        }

        @Override
        public IndexRangeTuple tuple() {
            return new IndexRangeTuple(this.lower, this.upper, this.contained());
        }
    }

    public static class IndexRangeTuple {
        final long lower;
        final long upper;
        final boolean contained;

        IndexRangeTuple(long lower, long upper, boolean contained) {
            this.lower = lower;
            this.upper = upper;
            this.contained = contained;
        }
    }

    public static interface IndexRange {
        public long lower();

        public long upper();

        public boolean contained();

        public IndexRangeTuple tuple();
    }

    public static class RangeComputeHints
    extends HashMap<String, Object> {
    }
}

