/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.InferTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.util.List;

public class SqlAsOperator
extends SqlSpecialOperator {
    public SqlAsOperator() {
        this("AS", SqlKind.AS, 20, true, ReturnTypes.ARG0, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)OperandTypes.ANY_IGNORE);
    }

    protected SqlAsOperator(String name, SqlKind kind, int prec, boolean leftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, prec, leftAssoc, returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() >= 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.AS);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, this.getLeftPrec());
        boolean needsSpace = true;
        writer.setNeedWhitespace(true);
        if (writer.getDialect().allowsAs()) {
            writer.sep("AS");
            writer.setNeedWhitespace(true);
        }
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        if (call.operandCount() > 2) {
            SqlWriter.Frame frame1 = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE, "(", ")");
            for (SqlNode operand : Util.skip(call.getOperandList(), 2)) {
                writer.sep(",", false);
                operand.unparse(writer, 0, 0);
            }
            writer.endList(frame1);
        }
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 2);
        assert (operands.get(1) instanceof SqlIdentifier);
        operands.get(0).validateExpr(validator, scope);
        SqlIdentifier id = (SqlIdentifier)operands.get(1);
        if (!id.isSimple()) {
            throw validator.newValidationError(id, Static.RESOURCE.aliasMustBeSimpleIdentifier());
        }
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType nodeType = validator.deriveType(scope, (SqlNode)call.operand(0));
        assert (nodeType != null);
        return this.validateOperands(validator, scope, call);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0);
    }
}

