/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.nio.charset.Charset;
import java.util.Objects;

public class SqlBasicTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlTypeName sqlTypeName;
    private int precision;
    private int scale;
    private @Nullable String charSetName;

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, int scale, @Nullable String charSetName, SqlParserPos pos) {
        super(new SqlIdentifier(typeName.name(), pos), pos);
        this.sqlTypeName = typeName;
        this.precision = precision;
        this.scale = scale;
        this.charSetName = charSetName;
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, SqlParserPos pos) {
        this(typeName, -1, -1, null, pos);
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, SqlParserPos pos) {
        this(typeName, precision, -1, null, pos);
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, String charSetName, SqlParserPos pos) {
        this(typeName, precision, -1, charSetName, pos);
    }

    public SqlBasicTypeNameSpec(SqlTypeName typeName, int precision, int scale, SqlParserPos pos) {
        this(typeName, precision, scale, null, pos);
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public @Nullable String getCharSetName() {
        return this.charSetName;
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec node, Litmus litmus) {
        if (!(node instanceof SqlBasicTypeNameSpec)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlBasicTypeNameSpec that = (SqlBasicTypeNameSpec)node;
        if (this.sqlTypeName != that.sqlTypeName) {
            return litmus.fail("{} != {}", this, node);
        }
        if (this.precision != that.precision) {
            return litmus.fail("{} != {}", this, node);
        }
        if (this.scale != that.scale) {
            return litmus.fail("{} != {}", this, node);
        }
        if (!Objects.equals(this.charSetName, that.charSetName)) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        boolean isWithLocalTimeZone = SqlBasicTypeNameSpec.isWithLocalTimeZoneDef(this.sqlTypeName);
        if (isWithLocalTimeZone) {
            writer.keyword(SqlBasicTypeNameSpec.stripLocalTimeZoneDef(this.sqlTypeName).name());
        } else {
            writer.keyword(this.getTypeName().getSimple());
        }
        if (this.sqlTypeName.allowsPrec() && this.precision >= 0) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            writer.print(this.precision);
            if (this.sqlTypeName.allowsScale() && this.scale >= 0) {
                writer.sep(",", true);
                writer.print(this.scale);
            }
            writer.endList(frame);
        }
        if (isWithLocalTimeZone) {
            writer.keyword("WITH LOCAL TIME ZONE");
        }
        if (this.charSetName != null) {
            writer.keyword("CHARACTER SET");
            writer.identifier(this.charSetName, true);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        RelDataType type;
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        if (this.precision >= 0 && this.scale >= 0) {
            assert (this.sqlTypeName.allowsPrecScale(true, true));
            type = typeFactory.createSqlType(this.sqlTypeName, this.precision, this.scale);
        } else if (this.precision >= 0) {
            assert (this.sqlTypeName.allowsPrecNoScale());
            type = typeFactory.createSqlType(this.sqlTypeName, this.precision);
        } else {
            assert (this.sqlTypeName.allowsNoPrecNoScale());
            type = typeFactory.createSqlType(this.sqlTypeName);
        }
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset charset;
            SqlCollation collation = SqlCollation.COERCIBLE;
            if (null == this.charSetName) {
                charset = typeFactory.getDefaultCharset();
            } else {
                String javaCharSetName = Objects.requireNonNull(SqlUtil.translateCharacterSetName(this.charSetName), this.charSetName);
                charset = Charset.forName(javaCharSetName);
            }
            type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        }
        return type;
    }

    private static boolean isWithLocalTimeZoneDef(SqlTypeName typeName) {
        switch (typeName) {
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return true;
            }
        }
        return false;
    }

    private static SqlTypeName stripLocalTimeZoneDef(SqlTypeName typeName) {
        switch (typeName) {
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return SqlTypeName.TIME;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return SqlTypeName.TIMESTAMP;
            }
        }
        throw new AssertionError((Object)typeName);
    }
}

