/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlPivot;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class SqlUnpivot
extends SqlCall {
    public SqlNode query;
    public final boolean includeNulls;
    public final SqlNodeList measureList;
    public final SqlNodeList axisList;
    public final SqlNodeList inList;
    static final Operator OPERATOR = new Operator(SqlKind.UNPIVOT);

    public SqlUnpivot(SqlParserPos pos, SqlNode query, boolean includeNulls, SqlNodeList measureList, SqlNodeList axisList, SqlNodeList inList) {
        super(pos);
        this.query = Objects.requireNonNull(query, "query");
        this.includeNulls = includeNulls;
        this.measureList = Objects.requireNonNull(measureList, "measureList");
        this.axisList = Objects.requireNonNull(axisList, "axisList");
        this.inList = Objects.requireNonNull(inList, "inList");
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.query, this.measureList, this.axisList, this.inList);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                this.query = operand;
                break;
            }
            default: {
                super.setOperand(i, operand);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.query.unparse(writer, leftPrec, 0);
        writer.keyword("UNPIVOT");
        writer.keyword(this.includeNulls ? "INCLUDE NULLS" : "EXCLUDE NULLS");
        SqlWriter.Frame frame = writer.startList("(", ")");
        int leftPrec1 = this.measureList.size() > 1 ? 1 : 0;
        this.measureList.unparse(writer, leftPrec1, 0);
        writer.sep("FOR");
        int leftPrec2 = this.axisList.size() > 1 ? 1 : 0;
        this.axisList.unparse(writer, leftPrec2, 0);
        writer.sep("IN");
        writer.list(SqlWriter.FrameTypeEnum.PARENTHESES, SqlWriter.COMMA, SqlPivot.stripList(this.inList));
        writer.endList(frame);
    }

    public void forEachMeasure(Consumer<SqlIdentifier> consumer) {
        this.measureList.forEach(consumer);
    }

    public void forEachNameValues(BiConsumer<SqlNodeList, @Nullable SqlNodeList> consumer) {
        block3: for (SqlNode node : this.inList) {
            switch (node.getKind()) {
                case AS: {
                    SqlCall call = (SqlCall)node;
                    assert (call.getOperandList().size() == 2);
                    SqlNodeList nodeList = (SqlNodeList)call.operand(0);
                    SqlNodeList valueList = (SqlNodeList)call.operand(1);
                    consumer.accept(nodeList, valueList);
                    continue block3;
                }
            }
            SqlNodeList nodeList2 = (SqlNodeList)node;
            consumer.accept(nodeList2, null);
        }
    }

    public Set<String> usedColumnNames() {
        final HashSet<String> columnNames = new HashSet<String>();
        SqlBasicVisitor<Void> nameCollector = new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlIdentifier id) {
                columnNames.add(Util.last(id.names));
                return (Void)super.visit(id);
            }
        };
        this.forEachNameValues((aliasList, valueList) -> {
            Void cfr_ignored_0 = (Void)aliasList.accept(nameCollector);
        });
        return columnNames;
    }

    public static String aliasValue(SqlNodeList aliasList) {
        StringBuilder b = new StringBuilder();
        aliasList.forEach(alias -> {
            if (b.length() > 0) {
                b.append('_');
            }
            b.append(Util.last(((SqlIdentifier)alias).names));
        });
        return b.toString();
    }

    static class Operator
    extends SqlSpecialOperator {
        Operator(SqlKind kind) {
            super(kind.name(), kind);
        }
    }
}

