/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.fun;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAggFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSplittableAggFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.shaded.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.shaded.org.apache.calcite.util.Optionality;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlBitOpAggFunction
extends SqlAggFunction {
    public SqlBitOpAggFunction(SqlKind kind) {
        super(kind.name(), null, kind, ReturnTypes.ARG0_NULLABLE_IF_EMPTY, null, OperandTypes.or(OperandTypes.INTEGER, OperandTypes.BINARY), SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
        Preconditions.checkArgument(kind == SqlKind.BIT_AND || kind == SqlKind.BIT_OR || kind == SqlKind.BIT_XOR);
    }

    @Override
    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz == SqlSplittableAggFunction.class) {
            return clazz.cast(SqlSplittableAggFunction.SelfSplitter.INSTANCE);
        }
        return super.unwrap(clazz);
    }

    @Override
    public Optionality getDistinctOptionality() {
        Optionality optionality;
        switch (this.kind) {
            case BIT_AND: 
            case BIT_OR: {
                optionality = Optionality.IGNORED;
                break;
            }
            default: {
                optionality = Optionality.OPTIONAL;
            }
        }
        return optionality;
    }
}

