/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.com.google.common.base.Preconditions;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class MatchReturnTypeInference
implements SqlReturnTypeInference {
    private final int start;
    private final List<SqlTypeName> typeNames;

    public MatchReturnTypeInference(int start, SqlTypeName ... typeNames) {
        this(start, ImmutableList.copyOf(typeNames));
    }

    public MatchReturnTypeInference(int start, Iterable<SqlTypeName> typeNames) {
        Preconditions.checkArgument(start >= 0);
        this.start = start;
        this.typeNames = ImmutableList.copyOf(typeNames);
        Preconditions.checkArgument(!this.typeNames.isEmpty());
    }

    @Override
    public @Nullable RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (int i = this.start; i < opBinding.getOperandCount(); ++i) {
            RelDataType argType = opBinding.getOperandType(i);
            if (!SqlTypeUtil.isOfSameTypeName(this.typeNames, argType)) continue;
            return argType;
        }
        return null;
    }
}

