/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlAbstractGroupFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggFinder;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlNameMatcher;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Objects;

abstract class AggVisitor
extends SqlBasicVisitor<Void> {
    protected final SqlOperatorTable opTab;
    protected final boolean over;
    protected final @Nullable AggFinder delegate;
    protected final boolean aggregate;
    protected final boolean group;
    protected final SqlNameMatcher nameMatcher;

    AggVisitor(SqlOperatorTable opTab, boolean over, boolean aggregate, boolean group, @Nullable AggFinder delegate, SqlNameMatcher nameMatcher) {
        this.group = group;
        this.over = over;
        this.aggregate = aggregate;
        this.delegate = delegate;
        this.opTab = Objects.requireNonNull(opTab, "opTab");
        this.nameMatcher = Objects.requireNonNull(nameMatcher, "nameMatcher");
    }

    @Override
    public Void visit(SqlCall call) {
        SqlFunction sqlFunction;
        SqlOperator operator = call.getOperator();
        if (operator.isAggregator() && !(operator instanceof SqlAbstractGroupFunction) && !operator.requiresOver()) {
            if (this.delegate != null) {
                return operator.acceptCall(this.delegate, call);
            }
            if (this.aggregate) {
                return this.found(call);
            }
        }
        if (this.group && operator.isGroup()) {
            return this.found(call);
        }
        if (operator instanceof SqlFunction && (sqlFunction = (SqlFunction)operator).getFunctionType().isUserDefinedNotSpecificFunction()) {
            ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
            SqlIdentifier identifier = sqlFunction.getSqlIdentifier();
            if (identifier != null) {
                this.opTab.lookupOperatorOverloads(identifier, sqlFunction.getFunctionType(), SqlSyntax.FUNCTION, list, this.nameMatcher);
                for (SqlOperator operator2 : list) {
                    if (!operator2.isAggregator() || operator2.requiresOver() || !this.aggregate) continue;
                    this.found(call);
                }
            }
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        if (call.getKind() == SqlKind.WITHIN_GROUP && this.aggregate) {
            return this.found(call);
        }
        if (call.getKind() == SqlKind.OVER) {
            if (this.over) {
                return this.found(call);
            }
            return null;
        }
        return (Void)super.visit(call);
    }

    protected abstract Void found(SqlCall var1);
}

