/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.com.google.common.base.Suppliers;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSortedMultiset;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggregatingScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.DelegatingScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;
    private @Nullable SqlValidatorUtil.GroupAnalyzer groupAnalyzer;
    public final Supplier<Resolved> resolved = Suppliers.memoize(this::resolve)::get;

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select, boolean distinct) {
        super(selectScope);
        this.select = select;
        this.distinct = distinct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resolved resolve() {
        SqlValidatorUtil.GroupAnalyzer groupAnalyzer;
        assert (this.groupAnalyzer == null) : "resolve already in progress";
        this.groupAnalyzer = groupAnalyzer = new SqlValidatorUtil.GroupAnalyzer();
        try {
            ImmutableList.Builder<ImmutableList<ImmutableBitSet>> builder = ImmutableList.builder();
            boolean groupByDistinct = false;
            if (this.select.getGroup() != null) {
                SqlNodeList groupList = this.select.getGroup();
                if (groupList.size() == 1 && groupList.get(0).getKind() == SqlKind.GROUP_BY_DISTINCT) {
                    groupList = new SqlNodeList(((SqlCall)groupList.get(0)).getOperandList(), groupList.getParserPosition());
                    groupByDistinct = true;
                }
                for (SqlNode sqlNode : groupList) {
                    SqlValidatorUtil.analyzeGroupItem(this, groupAnalyzer, builder, sqlNode);
                }
            }
            ArrayList<ImmutableBitSet> flatGroupSets = new ArrayList<ImmutableBitSet>();
            for (List list : Linq4j.product(builder.build())) {
                flatGroupSets.add(ImmutableBitSet.union(list));
            }
            if (flatGroupSets.isEmpty()) {
                flatGroupSets.add(ImmutableBitSet.of());
            }
            if (groupByDistinct) {
                ImmutableSet sets = ImmutableSet.copyOf(flatGroupSets);
                flatGroupSets.clear();
                flatGroupSets.addAll(sets);
            }
            Resolved resolved = new Resolved(groupAnalyzer.extraExprs, groupAnalyzer.groupExprs, flatGroupSets, groupAnalyzer.groupExprProjection);
            return resolved;
        }
        finally {
            this.groupAnalyzer = null;
        }
    }

    private Pair<ImmutableList<SqlNode>, ImmutableList<SqlNode>> getGroupExprs() {
        if (this.distinct) {
            assert (this.select.isDistinct());
            ImmutableList.Builder groupExprs = ImmutableList.builder();
            SelectScope selectScope = (SelectScope)this.parent;
            List<SqlNode> expandedSelectList = Objects.requireNonNull(selectScope.getExpandedSelectList(), () -> "expandedSelectList for " + selectScope);
            for (SqlNode selectItem : expandedSelectList) {
                groupExprs.add(SqlUtil.stripAs(selectItem));
            }
            return Pair.of(ImmutableList.of(), groupExprs.build());
        }
        if (this.select.getGroup() != null) {
            SqlValidatorUtil.GroupAnalyzer groupAnalyzer = this.groupAnalyzer;
            if (groupAnalyzer != null) {
                return Pair.of(ImmutableList.of(), ImmutableList.copyOf(groupAnalyzer.groupExprs));
            }
            Resolved resolved = this.resolved.get();
            return Pair.of(resolved.extraExprList, resolved.groupExprList);
        }
        return Pair.of(ImmutableList.of(), ImmutableList.of());
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        Resolved r = this.resolved.get();
        for (Ord<SqlNode> groupExpr : Ord.zip(r.groupExprList)) {
            if (!((SqlNode)groupExpr.e).equalsDeep(node, Litmus.IGNORE) || !r.isNullable(groupExpr.i)) continue;
            return this.validator.getTypeFactory().createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        Pair<ImmutableList<SqlNode>, ImmutableList<SqlNode>> pair = this.getGroupExprs();
        AggChecker aggChecker = new AggChecker(this.validator, this, (List)pair.left, (List)pair.right, this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public static class Resolved {
        public final ImmutableList<SqlNode> extraExprList;
        public final ImmutableList<SqlNode> groupExprList;
        public final ImmutableBitSet groupSet;
        public final ImmutableSortedMultiset<ImmutableBitSet> groupSets;
        public final Map<Integer, Integer> groupExprProjection;

        Resolved(List<SqlNode> extraExprList, List<SqlNode> groupExprList, Iterable<ImmutableBitSet> groupSets, Map<Integer, Integer> groupExprProjection) {
            this.extraExprList = ImmutableList.copyOf(extraExprList);
            this.groupExprList = ImmutableList.copyOf(groupExprList);
            this.groupSet = ImmutableBitSet.range(groupExprList.size());
            this.groupSets = ImmutableSortedMultiset.copyOf(groupSets);
            this.groupExprProjection = ImmutableMap.copyOf(groupExprProjection);
        }

        public boolean isNullable(int i) {
            return i < this.groupExprList.size() && !ImmutableBitSet.allContain(this.groupSets, i);
        }

        public boolean isGroupingExpr(SqlNode operand) {
            return this.lookupGroupingExpr(operand) >= 0;
        }

        public int lookupGroupingExpr(SqlNode operand) {
            for (Ord<SqlNode> groupExpr : Ord.zip(this.groupExprList)) {
                if (!operand.equalsDeep((SqlNode)groupExpr.e, Litmus.IGNORE)) continue;
                return groupExpr.i;
            }
            return -1;
        }
    }
}

