/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlTableFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        RelDataType type = this.validator.deriveTypeImpl(this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        SqlCallBinding callBinding = new SqlCallBinding(this.validator, this.scope, this.call);
        if (!(operator instanceof SqlTableFunction)) {
            throw new IllegalArgumentException("Argument must be a table function: " + operator.getNameAsId());
        }
        SqlTableFunction tableFunction = (SqlTableFunction)((Object)operator);
        if (type.getSqlTypeName() != SqlTypeName.CURSOR) {
            throw new IllegalArgumentException("Table function should have CURSOR type, not " + type);
        }
        SqlReturnTypeInference rowTypeInference = tableFunction.getRowTypeInference();
        return Objects.requireNonNull(rowTypeInference.inferReturnType(callBinding), () -> "got null from inferReturnType for call " + callBinding.getCall());
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.call;
    }
}

