/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.org.apache.calcite.avatica.util.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeStringUtils {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String ISO_DATETIME_FRACTIONAL_SECOND_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private DateTimeStringUtils() {
    }

    static String pad(int length, long v) {
        StringBuilder s2 = new StringBuilder(Long.toString(v));
        while (s2.length() < length) {
            s2.insert(0, "0");
        }
        return s2.toString();
    }

    static StringBuilder hms(StringBuilder b, int h2, int m4, int s2) {
        DateTimeStringUtils.int2(b, h2);
        b.append(':');
        DateTimeStringUtils.int2(b, m4);
        b.append(':');
        DateTimeStringUtils.int2(b, s2);
        return b;
    }

    static StringBuilder ymdhms(StringBuilder b, int year, int month, int day, int h2, int m4, int s2) {
        DateTimeStringUtils.ymd(b, year, month, day);
        b.append(' ');
        DateTimeStringUtils.hms(b, h2, m4, s2);
        return b;
    }

    static StringBuilder ymd(StringBuilder b, int year, int month, int day) {
        DateTimeStringUtils.int4(b, year);
        b.append('-');
        DateTimeStringUtils.int2(b, month);
        b.append('-');
        DateTimeStringUtils.int2(b, day);
        return b;
    }

    private static void int4(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 1000 % 10));
        buf.append((char)(48 + i / 100 % 10));
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    private static void int2(StringBuilder buf, int i) {
        buf.append((char)(48 + i / 10 % 10));
        buf.append((char)(48 + i % 10));
    }

    static boolean isValidTimeZone(String timeZone) {
        if (timeZone.equals("GMT")) {
            return true;
        }
        String id = TimeZone.getTimeZone(timeZone).getID();
        return !id.equals("GMT");
    }

    public static SimpleDateFormat getDateFormatter(String format) {
        return DateTimeStringUtils.getDateFormatter(format, DateTimeUtils.UTC_ZONE);
    }

    public static SimpleDateFormat getDateFormatter(String format, TimeZone timeZone) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(format, Locale.ROOT);
        dateFormatter.setTimeZone(timeZone);
        return dateFormatter;
    }
}

