/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.function.Supplier;

public class TryThreadLocal<@Nullable T>
extends ThreadLocal<T> {
    private final T initialValue;

    public static <T> TryThreadLocal<T> of(T initialValue) {
        return new TryThreadLocal<T>(initialValue);
    }

    private TryThreadLocal(T initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    protected final T initialValue() {
        return this.initialValue;
    }

    public Memo push(T value) {
        Object previous = this.get();
        this.set(value);
        return () -> this.restoreTo(previous);
    }

    protected void restoreTo(T previous) {
        if (previous == this.initialValue) {
            this.remove();
        } else {
            this.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void letIn(T t2, Runnable runnable) {
        Object previous = this.get();
        if (previous == t2) {
            runnable.run();
        } else {
            try {
                this.set(t2);
                runnable.run();
            }
            finally {
                this.restoreTo(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R letIn(T t2, Supplier<R> supplier) {
        Object previous = this.get();
        if (previous == t2) {
            return supplier.get();
        }
        try {
            this.set(t2);
            R r = supplier.get();
            return r;
        }
        finally {
            this.restoreTo(previous);
        }
    }

    public static interface Memo
    extends AutoCloseable {
        @Override
        public void close();
    }
}

