/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json;

import com.hazelcast.shaded.org.jsfr.json.PrimitiveHolder;
import com.hazelcast.shaded.org.jsfr.json.SurfingConfiguration;
import java.io.IOException;

public abstract class AbstractPrimitiveHolder
implements PrimitiveHolder {
    private boolean executed;
    private Object value;
    private final SurfingConfiguration surfingConfiguration;

    public AbstractPrimitiveHolder(SurfingConfiguration surfingConfiguration) {
        this.surfingConfiguration = surfingConfiguration;
    }

    public void init() {
        this.executed = false;
        this.value = null;
    }

    @Override
    public Object getValue() {
        if (this.executed) {
            return this.value;
        }
        this.executed = true;
        try {
            this.value = this.doGetValue();
        }
        catch (Exception e) {
            this.surfingConfiguration.getErrorHandlingStrategy().handleParsingException(e);
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.executed = true;
        this.value = value;
    }

    public void skipValue() {
        if (!this.executed) {
            this.executed = true;
            try {
                this.doSkipValue();
            }
            catch (Exception e) {
                this.surfingConfiguration.getErrorHandlingStrategy().handleParsingException(e);
            }
        }
    }

    protected abstract void doSkipValue() throws IOException;

    protected abstract Object doGetValue() throws IOException;
}

