/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json;

import com.hazelcast.shaded.org.jsfr.json.DispatchUtil;
import com.hazelcast.shaded.org.jsfr.json.JsonDomBuilder;
import com.hazelcast.shaded.org.jsfr.json.JsonPathListener;
import com.hazelcast.shaded.org.jsfr.json.ParsingContext;
import com.hazelcast.shaded.org.jsfr.json.SurfingConfiguration;
import java.util.Collection;

class JsonCollector
extends JsonDomBuilder {
    private Collection<JsonPathListener> jsonPathListeners;
    private ParsingContext context;
    private SurfingConfiguration config;

    JsonCollector(Collection<JsonPathListener> jsonPathListeners, ParsingContext context, SurfingConfiguration config) {
        super(config.getJsonProvider());
        this.jsonPathListeners = jsonPathListeners;
        this.context = context;
        this.config = config;
    }

    @Override
    public boolean endObject() {
        super.endObject();
        if (this.isInRoot()) {
            Object result = this.rootValue();
            DispatchUtil.dispatchValueToListeners(result, this.jsonPathListeners, this.context, this.config.getErrorHandlingStrategy());
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public boolean endArray() {
        super.endArray();
        if (this.isInRoot()) {
            Object result = this.rootValue();
            DispatchUtil.dispatchValueToListeners(result, this.jsonPathListeners, this.context, this.config.getErrorHandlingStrategy());
            this.clear();
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.context = null;
        this.jsonPathListeners = null;
        this.config = null;
    }
}

