/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json.filter;

import com.hazelcast.shaded.org.jsfr.json.provider.JsonProvider;
import java.util.HashMap;
import java.util.Map;

public enum Type {
    NULL{

        @Override
        public boolean isInstanceOf(Object obj, JsonProvider<?, ?, ?> provider) {
            return provider.isPrimitiveNull(obj);
        }
    }
    ,
    NUMBER{

        @Override
        public boolean isInstanceOf(Object obj, JsonProvider<?, ?, ?> provider) {
            return provider.isPrimitiveNumber(obj);
        }
    }
    ,
    STRING{

        @Override
        public boolean isInstanceOf(Object obj, JsonProvider<?, ?, ?> provider) {
            return provider.isPrimitiveString(obj);
        }
    }
    ,
    BOOLEAN{

        @Override
        public boolean isInstanceOf(Object obj, JsonProvider<?, ?, ?> provider) {
            return provider.isPrimitiveBoolean(obj);
        }
    }
    ,
    ARRAY,
    OBJECT;

    private static final Map<String, Type> NAME_TO_TYPE_MAPPING;

    public boolean isInstanceOf(Object obj, JsonProvider<?, ?, ?> provider) {
        throw new UnsupportedOperationException("should not be called");
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static Type from(String value) {
        return NAME_TO_TYPE_MAPPING.get(value);
    }

    static {
        NAME_TO_TYPE_MAPPING = new HashMap<String, Type>();
        for (Type item : Type.values()) {
            NAME_TO_TYPE_MAPPING.put(item.toString(), item);
        }
    }
}

