/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json.path;

import com.hazelcast.shaded.org.jsfr.json.filter.JsonPathFilter;
import com.hazelcast.shaded.org.jsfr.json.path.ArrayIndex;
import com.hazelcast.shaded.org.jsfr.json.path.FilterableChildNode;
import com.hazelcast.shaded.org.jsfr.json.path.PathOperator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ArrayIndexes
extends FilterableChildNode {
    private final Set<Integer> indexes;
    private final TreeMap<Integer, Integer> ranges;

    public ArrayIndexes(String key, JsonPathFilter jsonPathFilter, Set<Integer> indexes, TreeMap<Integer, Integer> ranges) {
        super(key, jsonPathFilter);
        this.indexes = indexes;
        this.ranges = ranges;
    }

    @Override
    public boolean match(PathOperator pathOperator) {
        if (!super.match(pathOperator)) {
            return false;
        }
        if (pathOperator instanceof ArrayIndex) {
            int arrayIndex = ((ArrayIndex)pathOperator).getArrayIndex();
            if (this.indexes.contains(arrayIndex)) {
                return true;
            }
            Map.Entry<Integer, Integer> range = this.ranges.floorEntry(arrayIndex);
            return range != null && range.getValue() >= arrayIndex;
        }
        throw new IllegalStateException("unexpected path operator: " + pathOperator);
    }

    @Override
    public PathOperator.Type getType() {
        return PathOperator.Type.ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(super.toString());
        res.append('[');
        for (Integer n : this.indexes) {
            res.append(n).append(',');
        }
        for (Map.Entry entry : this.ranges.entrySet()) {
            res.append(entry.getKey()).append(" to ").append(entry.getValue()).append(',');
        }
        if (res.length() == 1) {
            res.append(']');
        } else {
            res.setCharAt(res.length() - 1, ']');
        }
        res.append(super.getJsonPathFilter() != null ? "?(@...)" : "");
        return res.toString();
    }
}

