/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFactory;
import com.hazelcast.shaded.org.locationtech.jts.io.OrdinateFormat;

public class CoordinateSequences {
    public static void reverse(CoordinateSequence seq) {
        if (seq.size() <= 1) {
            return;
        }
        int last = seq.size() - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            CoordinateSequences.swap(seq, i, last - i);
        }
    }

    public static void swap(CoordinateSequence seq, int i, int j) {
        if (i == j) {
            return;
        }
        for (int dim = 0; dim < seq.getDimension(); ++dim) {
            double tmp = seq.getOrdinate(i, dim);
            seq.setOrdinate(i, dim, seq.getOrdinate(j, dim));
            seq.setOrdinate(j, dim, tmp);
        }
    }

    public static void copy(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            CoordinateSequences.copyCoord(src, srcPos + i, dest, destPos + i);
        }
    }

    public static void copyCoord(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos) {
        int minDim = Math.min(src.getDimension(), dest.getDimension());
        for (int dim = 0; dim < minDim; ++dim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
        }
    }

    public static boolean isRing(CoordinateSequence seq) {
        int n = seq.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        return seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq) {
        boolean isClosed;
        int n = seq.size();
        if (n == 0) {
            return seq;
        }
        if (n <= 3) {
            return CoordinateSequences.createClosedRing(fact, seq, 4);
        }
        boolean bl = isClosed = seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
        if (isClosed) {
            return seq;
        }
        return CoordinateSequences.createClosedRing(fact, seq, n + 1);
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        for (int i = n; i < size; ++i) {
            CoordinateSequences.copy(seq, 0, newseq, i, 1);
        }
        return newseq;
    }

    public static CoordinateSequence extend(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        if (n > 0) {
            for (int i = n; i < size; ++i) {
                CoordinateSequences.copy(seq, n - 1, newseq, i, 1);
            }
        }
        return newseq;
    }

    public static boolean isEqual(CoordinateSequence cs1, CoordinateSequence cs2) {
        int cs2Size;
        int cs1Size = cs1.size();
        if (cs1Size != (cs2Size = cs2.size())) {
            return false;
        }
        int dim = Math.min(cs1.getDimension(), cs2.getDimension());
        for (int i = 0; i < cs1Size; ++i) {
            for (int d = 0; d < dim; ++d) {
                double v1 = cs1.getOrdinate(i, d);
                double v2 = cs2.getOrdinate(i, d);
                if (cs1.getOrdinate(i, d) == cs2.getOrdinate(i, d) || Double.isNaN(v1) && Double.isNaN(v2)) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(CoordinateSequence cs) {
        int size = cs.size();
        if (size == 0) {
            return "()";
        }
        int dim = cs.getDimension();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            for (int d = 0; d < dim; ++d) {
                if (d > 0) {
                    builder.append(",");
                }
                builder.append(OrdinateFormat.DEFAULT.format(cs.getOrdinate(i, d)));
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public static Coordinate minCoordinate(CoordinateSequence seq) {
        Coordinate minCoord = null;
        for (int i = 0; i < seq.size(); ++i) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
        }
        return minCoord;
    }

    public static int minCoordinateIndex(CoordinateSequence seq) {
        return CoordinateSequences.minCoordinateIndex(seq, 0, seq.size() - 1);
    }

    public static int minCoordinateIndex(CoordinateSequence seq, int from, int to) {
        int minCoordIndex = -1;
        Coordinate minCoord = null;
        for (int i = from; i <= to; ++i) {
            Coordinate testCoord = seq.getCoordinate(i);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
            minCoordIndex = i;
        }
        return minCoordIndex;
    }

    public static void scroll(CoordinateSequence seq, Coordinate firstCoordinate) {
        int i = CoordinateSequences.indexOf(firstCoordinate, seq);
        if (i <= 0) {
            return;
        }
        CoordinateSequences.scroll(seq, i);
    }

    public static void scroll(CoordinateSequence seq, int indexOfFirstCoordinate) {
        CoordinateSequences.scroll(seq, indexOfFirstCoordinate, CoordinateSequences.isRing(seq));
    }

    public static void scroll(CoordinateSequence seq, int indexOfFirstCoordinate, boolean ensureRing) {
        int i = indexOfFirstCoordinate;
        if (i <= 0) {
            return;
        }
        CoordinateSequence copy = seq.copy();
        int last = ensureRing ? seq.size() - 1 : seq.size();
        for (int j = 0; j < last; ++j) {
            for (int k = 0; k < seq.getDimension(); ++k) {
                seq.setOrdinate(j, k, copy.getOrdinate((indexOfFirstCoordinate + j) % last, k));
            }
        }
        if (ensureRing) {
            for (int k = 0; k < seq.getDimension(); ++k) {
                seq.setOrdinate(last, k, seq.getOrdinate(0, k));
            }
        }
    }

    public static int indexOf(Coordinate coordinate, CoordinateSequence seq) {
        for (int i = 0; i < seq.size(); ++i) {
            if (coordinate.x != seq.getOrdinate(i, 0) || coordinate.y != seq.getOrdinate(i, 1)) continue;
            return i;
        }
        return -1;
    }
}

