/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geom;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceComparator;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryComponentFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.Puntal;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;

public class Point
extends Geometry
implements Puntal {
    private static final long serialVersionUID = 4902022702746614570L;
    private CoordinateSequence coordinates;

    public Point(Coordinate coordinate, PrecisionModel precisionModel, int SRID) {
        super(new GeometryFactory(precisionModel, SRID));
        Coordinate[] coordinateArray;
        CoordinateSequenceFactory coordinateSequenceFactory = this.getFactory().getCoordinateSequenceFactory();
        if (coordinate != null) {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = coordinate;
        } else {
            coordinateArray = new Coordinate[]{};
        }
        this.init(coordinateSequenceFactory.create(coordinateArray));
    }

    public Point(CoordinateSequence coordinates, GeometryFactory factory) {
        super(factory);
        this.init(coordinates);
    }

    private void init(CoordinateSequence coordinates) {
        if (coordinates == null) {
            coordinates = this.getFactory().getCoordinateSequenceFactory().create(new Coordinate[0]);
        }
        Assert.isTrue(coordinates.size() <= 1);
        this.coordinates = coordinates;
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray;
        if (this.isEmpty()) {
            coordinateArray = new Coordinate[]{};
        } else {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = this.getCoordinate();
        }
        return coordinateArray;
    }

    @Override
    public int getNumPoints() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.size() == 0;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public int getBoundaryDimension() {
        return -1;
    }

    public double getX() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getX called on empty Point");
        }
        return this.getCoordinate().x;
    }

    public double getY() {
        if (this.getCoordinate() == null) {
            throw new IllegalStateException("getY called on empty Point");
        }
        return this.getCoordinate().y;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coordinates.size() != 0 ? this.coordinates.getCoordinate(0) : null;
    }

    @Override
    public String getGeometryType() {
        return "Point";
    }

    @Override
    public Geometry getBoundary() {
        return this.getFactory().createGeometryCollection();
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        Envelope env = new Envelope();
        env.expandToInclude(this.coordinates.getX(0), this.coordinates.getY(0));
        return env;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.isEmpty() != other.isEmpty()) {
            return false;
        }
        return this.equal(((Point)other).getCoordinate(), this.getCoordinate(), tolerance);
    }

    @Override
    public void apply(CoordinateFilter filter) {
        if (this.isEmpty()) {
            return;
        }
        filter.filter(this.getCoordinate());
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        if (this.isEmpty()) {
            return;
        }
        filter.filter(this.coordinates, 0);
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected Point copyInternal() {
        return new Point(this.coordinates.copy(), this.factory);
    }

    @Override
    public Point reverse() {
        return (Point)super.reverse();
    }

    @Override
    protected Point reverseInternal() {
        return this.getFactory().createPoint(this.coordinates.copy());
    }

    @Override
    public void normalize() {
    }

    @Override
    protected int compareToSameClass(Object other) {
        Point point = (Point)other;
        return this.getCoordinate().compareTo(point.getCoordinate());
    }

    @Override
    protected int compareToSameClass(Object other, CoordinateSequenceComparator comp) {
        Point point = (Point)other;
        return comp.compare(this.coordinates, point.coordinates);
    }

    @Override
    protected int getTypeCode() {
        return 0;
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.coordinates;
    }
}

