/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.io.gml2;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.io.gml2.GeometryStrategies;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class GMLHandler
extends DefaultHandler {
    private Stack stack = new Stack();
    private ErrorHandler delegate = null;
    private GeometryFactory gf = null;
    private Locator locator = null;

    public GMLHandler(GeometryFactory gf, ErrorHandler delegate) {
        this.delegate = delegate;
        this.gf = gf;
        this.stack.push(new Handler(null, null));
    }

    public boolean isGeometryComplete() {
        if (this.stack.size() > 1) {
            return false;
        }
        Handler h2 = (Handler)this.stack.peek();
        return h2.children.size() >= 1;
    }

    public Geometry getGeometry() {
        if (this.stack.size() == 1) {
            Handler h2 = (Handler)this.stack.peek();
            if (h2.children.size() == 1) {
                return (Geometry)h2.children.get(0);
            }
            return this.gf.createGeometryCollection(h2.children.toArray(new Geometry[this.stack.size()]));
        }
        throw new IllegalStateException("Parse did not complete as expected, there are " + this.stack.size() + " elements on the Stack");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.stack.isEmpty()) {
            ((Handler)this.stack.peek()).addText(new String(ch, start, length));
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.stack.isEmpty()) {
            ((Handler)this.stack.peek()).addText(" ");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Handler thisAction = (Handler)this.stack.pop();
        ((Handler)this.stack.peek()).keep(thisAction.create(this.gf));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        GeometryStrategies.ParseStrategy ps = GeometryStrategies.findStrategy(uri, localName);
        if (ps == null) {
            String qn = qName.substring(qName.indexOf(58) + 1, qName.length());
            ps = GeometryStrategies.findStrategy(null, qn);
        }
        Handler h2 = new Handler(ps, attributes);
        this.stack.push(h2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.delegate instanceof ContentHandler) {
            ((ContentHandler)((Object)this.delegate)).setDocumentLocator(locator);
        }
    }

    protected Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.fatalError(e);
        } else {
            super.fatalError(e);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.error(e);
        } else {
            super.error(e);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.warning(e);
        } else {
            super.warning(e);
        }
    }

    static class Handler {
        protected Attributes attrs = null;
        protected GeometryStrategies.ParseStrategy strategy;
        protected StringBuffer text = null;
        protected List children = null;

        public Handler(GeometryStrategies.ParseStrategy strategy, Attributes attributes) {
            if (attributes != null) {
                this.attrs = new AttributesImpl(attributes);
            }
            this.strategy = strategy;
        }

        public void addText(String str) {
            if (this.text == null) {
                this.text = new StringBuffer();
            }
            this.text.append(str);
        }

        public void keep(Object obj) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            this.children.add(obj);
        }

        public Object create(GeometryFactory gf) throws SAXException {
            return this.strategy.parse(this, gf);
        }
    }
}

