/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.predicate;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;

class GeometryContainsPointVisitor
extends ShortCircuitedGeometryVisitor {
    private CoordinateSequence rectSeq;
    private Envelope rectEnv;
    private boolean containsPoint = false;

    public GeometryContainsPointVisitor(Polygon rectangle) {
        this.rectSeq = rectangle.getExteriorRing().getCoordinateSequence();
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean containsPoint() {
        return this.containsPoint;
    }

    @Override
    protected void visit(Geometry geom) {
        if (!(geom instanceof Polygon)) {
            return;
        }
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        Coordinate rectPt = new Coordinate();
        for (int i = 0; i < 4; ++i) {
            this.rectSeq.getCoordinate(i, rectPt);
            if (!elementEnv.contains(rectPt) || !SimplePointInAreaLocator.containsPointInPolygon(rectPt, (Polygon)geom)) continue;
            this.containsPoint = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.containsPoint;
    }
}

