/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.predicate;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Envelope;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Point;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;

public class RectangleContains {
    private Envelope rectEnv;

    public static boolean contains(Polygon rectangle, Geometry b) {
        RectangleContains rc = new RectangleContains(rectangle);
        return rc.contains(b);
    }

    public RectangleContains(Polygon rectangle) {
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean contains(Geometry geom) {
        if (!this.rectEnv.contains(geom.getEnvelopeInternal())) {
            return false;
        }
        return !this.isContainedInBoundary(geom);
    }

    private boolean isContainedInBoundary(Geometry geom) {
        if (geom instanceof Polygon) {
            return false;
        }
        if (geom instanceof Point) {
            return this.isPointContainedInBoundary((Point)geom);
        }
        if (geom instanceof LineString) {
            return this.isLineStringContainedInBoundary((LineString)geom);
        }
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.isContainedInBoundary(comp)) continue;
            return false;
        }
        return true;
    }

    private boolean isPointContainedInBoundary(Point point) {
        return this.isPointContainedInBoundary(point.getCoordinate());
    }

    private boolean isPointContainedInBoundary(Coordinate pt) {
        return pt.x == this.rectEnv.getMinX() || pt.x == this.rectEnv.getMaxX() || pt.y == this.rectEnv.getMinY() || pt.y == this.rectEnv.getMaxY();
    }

    private boolean isLineStringContainedInBoundary(LineString line) {
        CoordinateSequence seq = line.getCoordinateSequence();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        for (int i = 0; i < seq.size() - 1; ++i) {
            seq.getCoordinate(i, p0);
            seq.getCoordinate(i + 1, p1);
            if (this.isLineSegmentContainedInBoundary(p0, p1)) continue;
            return false;
        }
        return true;
    }

    private boolean isLineSegmentContainedInBoundary(Coordinate p0, Coordinate p1) {
        if (p0.equals(p1)) {
            return this.isPointContainedInBoundary(p0);
        }
        return p0.x == p1.x ? p0.x == this.rectEnv.getMinX() || p0.x == this.rectEnv.getMaxX() : p0.y == p1.y && (p0.y == this.rectEnv.getMinY() || p0.y == this.rectEnv.getMaxY());
    }
}

