/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.ResultIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UpdateSqlResultImpl
extends AbstractSqlResult {
    private final long updateCount;
    private final int partitionArgumentIndex;

    private UpdateSqlResultImpl(long updateCount, int partitionArgumentIndex) {
        this.updateCount = Preconditions.checkNotNegative((long)updateCount, (String)"the updateCount must be >= 0");
        this.partitionArgumentIndex = partitionArgumentIndex;
    }

    public static UpdateSqlResultImpl createUpdateCountResult(long updateCount) {
        return UpdateSqlResultImpl.createUpdateCountResult(updateCount, -1);
    }

    public static UpdateSqlResultImpl createUpdateCountResult(long updateCount, int partitionArgumentIndex) {
        return new UpdateSqlResultImpl(updateCount, partitionArgumentIndex);
    }

    @Nullable
    public QueryId getQueryId() {
        throw new IllegalStateException("This result contains only update count");
    }

    public boolean isInfiniteRows() {
        return false;
    }

    public int getPartitionArgumentIndex() {
        return this.partitionArgumentIndex;
    }

    @Nonnull
    public SqlRowMetadata getRowMetadata() {
        throw new IllegalStateException("This result contains only update count");
    }

    @Nonnull
    public ResultIterator<SqlRow> iterator() {
        throw new IllegalStateException("This result contains only update count");
    }

    public long updateCount() {
        return this.updateCount;
    }

    public void close(@Nullable QueryException error) {
    }
}

