/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public final class MapScanRow
implements Row {
    private final QueryTarget keyTarget;
    private final QueryTarget valueTarget;
    private final QueryExtractor[] fieldExtractors;

    private MapScanRow(QueryTarget keyTarget, QueryTarget valueTarget, QueryExtractor[] fieldExtractors) {
        this.keyTarget = keyTarget;
        this.valueTarget = valueTarget;
        this.fieldExtractors = fieldExtractors;
    }

    public static MapScanRow create(QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, Extractors extractors, InternalSerializationService serializationService) {
        QueryTarget keyTarget = keyDescriptor.create(serializationService, extractors, true);
        QueryTarget valueTarget = valueDescriptor.create(serializationService, extractors, false);
        QueryExtractor[] fieldExtractors = new QueryExtractor[fieldPaths.size()];
        for (int i = 0; i < fieldPaths.size(); ++i) {
            QueryPath fieldPath = fieldPaths.get(i);
            QueryDataType fieldType = fieldTypes.get(i);
            fieldExtractors[i] = MapScanRow.createExtractor(keyTarget, valueTarget, fieldPath, fieldType);
        }
        return new MapScanRow(keyTarget, valueTarget, fieldExtractors);
    }

    public void setKeyValue(Object rawKey, Data rawKeyData, Object rawValue, Data rawValueData) {
        this.keyTarget.setTarget(rawKey, rawKeyData);
        this.valueTarget.setTarget(rawValue, rawValueData);
    }

    public <T> T get(int idx) {
        return (T)this.fieldExtractors[idx].get();
    }

    public <T> T get(int idx, boolean useLazyDeserialization) {
        return (T)this.fieldExtractors[idx].get(useLazyDeserialization);
    }

    public int getColumnCount() {
        return this.fieldExtractors.length;
    }

    private static QueryExtractor createExtractor(QueryTarget keyTarget, QueryTarget valueTarget, QueryPath path, QueryDataType type) {
        QueryTarget target = path.isKey() ? keyTarget : valueTarget;
        return target.createExtractor(path.getPath(), type);
    }
}

