/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.UniExpression;
import com.hazelcast.sql.impl.expression.datetime.DateTimeUtils;
import com.hazelcast.sql.impl.expression.datetime.ExtractField;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;

public class ExtractFunction
extends UniExpression<Double> {
    private ExtractField extractField;

    public ExtractFunction() {
    }

    private ExtractFunction(Expression<?> time, ExtractField extractField) {
        super(time);
        this.extractField = extractField;
    }

    public static ExtractFunction create(Expression<?> time, ExtractField extractField) {
        return new ExtractFunction(time, extractField);
    }

    @Override
    public Double eval(Row row, ExpressionEvalContext context) {
        Object object = this.operand.eval(row, context);
        if (object == null) {
            return null;
        }
        try {
            return DateTimeUtils.extractField(object, this.extractField);
        }
        catch (IllegalArgumentException e) {
            throw QueryException.error((int)2000, (String)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.DOUBLE;
    }

    public int getClassId() {
        return 71;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeString(this.extractField.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.extractField = ExtractField.valueOf(in.readString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtractFunction that = (ExtractFunction)o;
        return this.extractField == that.extractField;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.extractField});
    }
}

