/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.BiExpressionWithType;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.math.BigDecimal;

public final class DivideFunction<T>
extends BiExpressionWithType<T> {
    public DivideFunction() {
    }

    private DivideFunction(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        super(operand1, operand2, resultType);
    }

    public static DivideFunction<?> create(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType) {
        return new DivideFunction(operand1, operand2, resultType);
    }

    public int getClassId() {
        return 37;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object left = this.operand1.eval(row, context);
        if (left == null) {
            return null;
        }
        Object right = this.operand2.eval(row, context);
        if (right == null) {
            return null;
        }
        QueryDataTypeFamily family = this.resultType.getTypeFamily();
        if (family.isTemporal()) {
            throw new UnsupportedOperationException("temporal types are unsupported currently");
        }
        return (T)DivideFunction.evalNumeric((Number)left, (Number)right, family);
    }

    private static Object evalNumeric(Number left, Number right, QueryDataTypeFamily family) {
        try {
            switch (family) {
                case TINYINT: {
                    return (byte)((long)left.byteValue() / right.longValue());
                }
                case SMALLINT: {
                    return (short)((long)left.shortValue() / right.longValue());
                }
                case INTEGER: {
                    return (int)((long)left.intValue() / right.longValue());
                }
                case BIGINT: {
                    return ExpressionMath.divideExact(left.longValue(), right.longValue());
                }
                case REAL: {
                    return Float.valueOf(ExpressionMath.divideExact(left.floatValue(), right.floatValue()));
                }
                case DOUBLE: {
                    return ExpressionMath.divideExact(left.doubleValue(), right.doubleValue());
                }
                case DECIMAL: {
                    return ((BigDecimal)left).divide((BigDecimal)right, QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
                }
            }
            throw new IllegalArgumentException("Unexpected result family: " + (Object)((Object)family));
        }
        catch (ArithmeticException e) {
            throw QueryException.error((int)2000, (String)"Division by zero", (Throwable)e);
        }
    }
}

