/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.BiExpressionWithType;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.MathFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RoundTruncateFunction<T>
extends BiExpressionWithType<T> {
    private boolean truncate;

    public RoundTruncateFunction() {
    }

    private RoundTruncateFunction(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType, boolean truncate) {
        super(operand1, operand2, resultType);
        this.truncate = truncate;
    }

    public static Expression<?> create(Expression<?> operand1, Expression<?> operand2, QueryDataType resultType, boolean truncate) {
        QueryDataType operand1Type;
        if (operand2 == null && MathFunctionUtils.notFractional(operand1Type = operand1.getType())) {
            assert (operand1Type == resultType);
            return operand1;
        }
        return new RoundTruncateFunction(operand1, operand2, resultType, truncate);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        Object operand1Value = this.operand1.eval(row, context);
        if (operand1Value == null) {
            return null;
        }
        int len = this.getLength(row, context);
        switch (this.resultType.getTypeFamily()) {
            case TINYINT: {
                try {
                    return (T)Byte.valueOf(this.execute(operand1Value, len).byteValueExact());
                }
                catch (ArithmeticException e) {
                    throw this.overflow(QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.SMALLINT, e);
                }
            }
            case SMALLINT: {
                try {
                    return (T)Short.valueOf(this.execute(operand1Value, len).shortValueExact());
                }
                catch (ArithmeticException e) {
                    throw this.overflow(QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.INTEGER, e);
                }
            }
            case INTEGER: {
                try {
                    return (T)Integer.valueOf(this.execute(operand1Value, len).intValueExact());
                }
                catch (ArithmeticException e) {
                    throw this.overflow(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.BIGINT, e);
                }
            }
            case BIGINT: {
                try {
                    return (T)Long.valueOf(this.execute(operand1Value, len).longValueExact());
                }
                catch (ArithmeticException e) {
                    throw this.overflow(QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.DECIMAL, e);
                }
            }
            case DECIMAL: {
                return (T)this.execute(operand1Value, len);
            }
            case REAL: {
                float floatValue = ((Float)operand1Value).floatValue();
                if (Float.isNaN(floatValue) || Float.isInfinite(floatValue)) {
                    return (T)Float.valueOf(floatValue);
                }
                return (T)Float.valueOf(this.execute(operand1Value, len).floatValue());
            }
            case DOUBLE: {
                double doubleValue = (Double)operand1Value;
                if (Double.isNaN(doubleValue) || Double.isInfinite(doubleValue)) {
                    return (T)Double.valueOf(doubleValue);
                }
                return (T)Double.valueOf(this.execute(operand1Value, len).doubleValue());
            }
        }
        throw QueryException.error((String)("Unsupported result type for " + this.getFunctionName() + " function: " + this.resultType));
    }

    private int getLength(Row row, ExpressionEvalContext context) {
        try {
            Integer operand2Value = this.operand2 != null ? MathFunctionUtils.asInt(this.operand2, row, context) : null;
            return operand2Value != null ? operand2Value : 0;
        }
        catch (Exception e) {
            throw QueryException.dataException((String)("Cannot convert the second operand of " + this.getFunctionName() + " function to " + (Object)((Object)QueryDataTypeFamily.INTEGER) + ": " + e.getMessage()), (Throwable)e);
        }
    }

    private BigDecimal execute(Object operand1Value, int len) {
        RoundingMode roundingMode;
        BigDecimal value = this.operand1.getType().getConverter().asDecimal(operand1Value);
        RoundingMode roundingMode2 = roundingMode = this.truncate ? RoundingMode.DOWN : RoundingMode.HALF_UP;
        if (len == 0) {
            return value.setScale(0, roundingMode);
        }
        return value.movePointRight(len).setScale(0, roundingMode).movePointLeft(len);
    }

    private QueryException overflow(QueryDataTypeFamily resultTypeFamily, QueryDataTypeFamily proposedTypeFamily, ArithmeticException cause) {
        return QueryException.dataException((String)((Object)((Object)resultTypeFamily) + " overflow in " + this.getFunctionName() + " function (consider adding an explicit CAST to " + (Object)((Object)proposedTypeFamily) + ")"), (Throwable)cause);
    }

    private String getFunctionName() {
        return this.truncate ? "TRUNCATE" : "ROUND";
    }

    public int getClassId() {
        return 56;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeBoolean(this.truncate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.truncate = in.readBoolean();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoundTruncateFunction that = (RoundTruncateFunction)o;
        return this.truncate == that.truncate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.truncate ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {operand1=" + this.operand1 + ", operand2=" + this.operand2 + ", truncate=" + this.truncate + '}';
    }
}

