/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MappingField
implements IdentifiedDataSerializable {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String EXTERNAL_NAME = "externalName";
    private static final String EXTERNAL_TYPE = "externalType";
    private static final String PRIMARY_KEY = "primaryKey";
    private Map<String, Object> properties;

    public MappingField() {
    }

    public MappingField(String name, QueryDataType type) {
        this(name, type, null, null);
    }

    public MappingField(String name, QueryDataType type, String externalName) {
        this(name, type, externalName, null);
    }

    public MappingField(String name, QueryDataType type, String externalName, String externalType) {
        this.properties = new HashMap<String, Object>();
        this.properties.put(NAME, Objects.requireNonNull(name));
        this.properties.put(TYPE, Objects.requireNonNull(type));
        if (externalName != null) {
            this.properties.put(EXTERNAL_NAME, externalName);
        }
        if (externalType != null) {
            this.properties.put(EXTERNAL_TYPE, externalType);
        }
    }

    @Nonnull
    public String name() {
        return Objects.requireNonNull((String)this.properties.get(NAME), "missing name property");
    }

    @Nonnull
    public QueryDataType type() {
        return Objects.requireNonNull((QueryDataType)this.properties.get(TYPE), "missing type property");
    }

    @Nonnull
    public MappingField setType(QueryDataType type) {
        this.properties.put(TYPE, type);
        return this;
    }

    public String externalName() {
        return (String)this.properties.get(EXTERNAL_NAME);
    }

    @Nonnull
    public MappingField setExternalName(String extName) {
        this.properties.put(EXTERNAL_NAME, extName);
        return this;
    }

    public boolean isPrimaryKey() {
        return (Boolean)this.properties.getOrDefault(PRIMARY_KEY, Boolean.FALSE);
    }

    @Nonnull
    public MappingField setPrimaryKey(boolean primaryKey) {
        this.properties.put(PRIMARY_KEY, primaryKey);
        return this;
    }

    @Nullable
    public String externalType() {
        return (String)this.properties.get(EXTERNAL_TYPE);
    }

    @Nonnull
    public MappingField setExternalType(@Nonnull String externalType) {
        this.properties.put(EXTERNAL_TYPE, externalType);
        return this;
    }

    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    public int getClassId() {
        return 58;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.properties);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.properties = (Map)in.readObject();
    }

    public String toString() {
        return "MappingField{properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingField that = (MappingField)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }
}

