/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.type;

import com.hazelcast.jet.sql.impl.parse.SqlCreateType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.schema.SqlCatalogObject;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class Type
implements Serializable,
SqlCatalogObject {
    private String name;
    private TypeKind kind = TypeKind.JAVA;
    private String javaClassName;
    private String compactTypeName;
    private Integer portableFactoryId;
    private Integer portableClassId;
    private Integer portableVersion;
    private List<TypeField> fields;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeKind getKind() {
        return this.kind;
    }

    public void setKind(TypeKind kind) {
        this.kind = kind;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public List<TypeField> getFields() {
        return this.fields;
    }

    public void setFields(List<TypeField> fields) {
        this.fields = fields;
    }

    public Integer getPortableFactoryId() {
        return this.portableFactoryId;
    }

    public void setPortableFactoryId(Integer portableFactoryId) {
        this.portableFactoryId = portableFactoryId;
    }

    public Integer getPortableClassId() {
        return this.portableClassId;
    }

    public void setPortableClassId(Integer portableClassId) {
        this.portableClassId = portableClassId;
    }

    public Integer getPortableVersion() {
        return this.portableVersion;
    }

    public void setPortableVersion(Integer portableVersion) {
        this.portableVersion = portableVersion;
    }

    public String getCompactTypeName() {
        return this.compactTypeName;
    }

    public void setCompactTypeName(String compactTypeName) {
        this.compactTypeName = compactTypeName;
    }

    public Map<String, String> options() {
        if (this.javaClassName != null) {
            return ImmutableMap.of("format", "java", "javaClass", this.javaClassName);
        }
        if (this.compactTypeName != null) {
            return ImmutableMap.of("format", "compact", "compactTypeName", this.compactTypeName);
        }
        if (this.portableFactoryId != null) {
            return ImmutableMap.of("format", "portable", "portableFactoryId", String.valueOf(this.portableFactoryId), "portableClassId", String.valueOf(this.portableClassId), "portableClassVersion", String.valueOf(this.portableVersion != null ? this.portableVersion : 0));
        }
        throw new AssertionError((Object)"unexpected state");
    }

    @Override
    @Nonnull
    public String unparse() {
        return SqlCreateType.unparse(this);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.kind.ordinal());
        switch (this.kind) {
            case JAVA: {
                out.writeString(this.javaClassName);
                break;
            }
            case PORTABLE: {
                out.writeInt(this.portableFactoryId.intValue());
                out.writeInt(this.portableClassId.intValue());
                out.writeInt(this.portableVersion.intValue());
                break;
            }
            case COMPACT: {
                out.writeString(this.compactTypeName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Type Kind: " + (Object)((Object)this.kind));
            }
        }
        out.writeInt(this.fields.size());
        for (TypeField field : this.fields) {
            out.writeObject((Object)field);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.kind = TypeKind.values()[in.readInt()];
        switch (this.kind) {
            case JAVA: {
                this.javaClassName = in.readString();
                break;
            }
            case PORTABLE: {
                this.portableFactoryId = in.readInt();
                this.portableClassId = in.readInt();
                this.portableVersion = in.readInt();
                break;
            }
            case COMPACT: {
                this.compactTypeName = in.readString();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Type Kind: " + (Object)((Object)this.kind));
            }
        }
        int size = in.readInt();
        this.fields = new ArrayList<TypeField>();
        for (int i = 0; i < size; ++i) {
            this.fields.add((TypeField)in.readObject());
        }
    }

    public int getClassId() {
        return 63;
    }

    public static class TypeField
    implements IdentifiedDataSerializable,
    Serializable {
        private String name;
        private QueryDataType queryDataType;

        public TypeField() {
        }

        public TypeField(String name, QueryDataType queryDataType) {
            this.name = name;
            this.queryDataType = queryDataType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public QueryDataType getQueryDataType() {
            return this.queryDataType;
        }

        public void setQueryDataType(QueryDataType queryDataType) {
            this.queryDataType = queryDataType;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.queryDataType == null ? -1 : this.queryDataType.getConverter().getId());
            out.writeString(this.queryDataType == null ? "" : this.queryDataType.getObjectTypeName());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = in.readString();
            int converterId = in.readInt();
            String typeName = in.readString();
            Converter converter = Converters.getConverter(converterId);
            this.queryDataType = converter.getTypeFamily().equals((Object)QueryDataTypeFamily.OBJECT) && typeName != null && !typeName.isEmpty() ? new QueryDataType(typeName) : QueryDataTypeUtils.resolveTypeForClass(converter.getValueClass());
        }

        public int getFactoryId() {
            return SqlDataSerializerHook.F_ID;
        }

        public int getClassId() {
            return 64;
        }
    }
}

