/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.DataConnectionConsistencyChecker;
import com.hazelcast.sql.impl.NodeServiceProvider;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.state.QueryClientStateRegistry;
import java.util.Set;
import java.util.UUID;

public class QueryStateRegistryUpdater {
    private final NodeServiceProvider nodeServiceProvider;
    private final QueryClientStateRegistry clientStateRegistry;
    private final PlanCacheChecker planCacheChecker;
    private final DataConnectionConsistencyChecker dataConnectionConsistencyChecker;
    private final ILogger logger;
    private volatile long stateCheckFrequency;
    private final Worker worker;

    public QueryStateRegistryUpdater(String instanceName, NodeServiceProvider nodeServiceProvider, QueryClientStateRegistry clientStateRegistry, PlanCacheChecker planCacheChecker, DataConnectionConsistencyChecker dataConnectionConsistencyChecker, long stateCheckFrequency) {
        if (stateCheckFrequency <= 0L) {
            throw new IllegalArgumentException("State check frequency must be positive: " + stateCheckFrequency);
        }
        this.nodeServiceProvider = nodeServiceProvider;
        this.clientStateRegistry = clientStateRegistry;
        this.planCacheChecker = planCacheChecker;
        this.dataConnectionConsistencyChecker = dataConnectionConsistencyChecker;
        this.stateCheckFrequency = stateCheckFrequency;
        this.logger = nodeServiceProvider.getLogger(this.getClass());
        this.worker = new Worker(instanceName);
    }

    public void start() {
        this.worker.start();
    }

    public void shutdown() {
        this.worker.stop();
    }

    public void setStateCheckFrequency(long stateCheckFrequency) {
        this.stateCheckFrequency = stateCheckFrequency;
        this.worker.thread.interrupt();
    }

    private final class Worker
    implements Runnable {
        private final Object startMux = new Object();
        private final String instanceName;
        private Thread thread;
        private volatile boolean stopped;

        private Worker(String instanceName) {
            this.instanceName = instanceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.startMux;
            synchronized (object) {
                if (this.stopped || this.thread != null) {
                    return;
                }
                Thread thread = new Thread(this);
                thread.setName(QueryUtils.workerName(this.instanceName, "query-state-checker"));
                thread.setDaemon(true);
                thread.start();
                this.thread = thread;
            }
        }

        @Override
        public void run() {
            while (!this.stopped) {
                long currentStateCheckFrequency = QueryStateRegistryUpdater.this.stateCheckFrequency;
                try {
                    Thread.sleep(currentStateCheckFrequency);
                    this.executeInterruptibly(this::checkClientState);
                    this.executeInterruptibly(this::checkPlans);
                    this.executeInterruptibly(this::checkDataConnectionsConsistency);
                }
                catch (InterruptedException e) {
                    if (currentStateCheckFrequency != QueryStateRegistryUpdater.this.stateCheckFrequency) continue;
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }

        private void executeInterruptibly(RunnableEx callback) throws InterruptedException {
            try {
                callback.runEx();
            }
            catch (InterruptedException i) {
                throw i;
            }
            catch (Throwable t2) {
                QueryStateRegistryUpdater.this.logger.warning("Unexpected error when invoking query state registry updater action", t2);
            }
        }

        private void checkClientState() {
            Set<UUID> activeClientIds = QueryStateRegistryUpdater.this.nodeServiceProvider.getClientIds();
            QueryStateRegistryUpdater.this.clientStateRegistry.update(activeClientIds);
        }

        private void checkPlans() {
            if (QueryStateRegistryUpdater.this.planCacheChecker != null) {
                QueryStateRegistryUpdater.this.planCacheChecker.check();
            }
        }

        private void checkDataConnectionsConsistency() {
            if (QueryStateRegistryUpdater.this.dataConnectionConsistencyChecker.isInitialized()) {
                try {
                    QueryStateRegistryUpdater.this.dataConnectionConsistencyChecker.check();
                }
                catch (Throwable t2) {
                    QueryStateRegistryUpdater.this.logger.warning(t2);
                }
            } else {
                if (QueryStateRegistryUpdater.this.nodeServiceProvider.getMap("__sql.catalog") == null) {
                    return;
                }
                if (!QueryStateRegistryUpdater.this.dataConnectionConsistencyChecker.isInitialized()) {
                    QueryStateRegistryUpdater.this.dataConnectionConsistencyChecker.init();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.startMux;
            synchronized (object) {
                if (this.stopped) {
                    return;
                }
                this.stopped = true;
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
        }
    }
}

