/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.SqlDaySecondInterval;
import com.hazelcast.sql.impl.type.SqlYearMonthInterval;
import com.hazelcast.sql.impl.type.converter.Converter;

@SerializableByConvention
public class IntervalConverter
extends Converter {
    public static final IntervalConverter YEAR_MONTH = new IntervalConverter(21, QueryDataTypeFamily.INTERVAL_YEAR_MONTH, SqlYearMonthInterval.class);
    public static final IntervalConverter DAY_SECOND = new IntervalConverter(22, QueryDataTypeFamily.INTERVAL_DAY_SECOND, SqlDaySecondInterval.class);
    private final Class<?> valueClass;

    public IntervalConverter(int id, QueryDataTypeFamily typeFamily, Class<?> valueClass) {
        super(id, typeFamily);
        this.valueClass = valueClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Object convertToSelf(Converter converter, Object val) {
        Object val0 = converter.asObject(val);
        if (val0 == null) {
            return null;
        }
        QueryDataTypeFamily family = this.getTypeFamily();
        if (family == QueryDataTypeFamily.INTERVAL_YEAR_MONTH) {
            if (val0 instanceof SqlYearMonthInterval) {
                return val0;
            }
        } else {
            assert (family == QueryDataTypeFamily.INTERVAL_DAY_SECOND);
            if (val0 instanceof SqlDaySecondInterval) {
                return val0;
            }
        }
        throw converter.cannotConvertError(family);
    }

    @Override
    public String toString() {
        return "IntervalConverter{" + (Object)((Object)this.getTypeFamily()) + '}';
    }
}

