/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.AbstractTemporalConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;

@SerializableByConvention
public final class LocalDateTimeConverter
extends AbstractTemporalConverter {
    public static final LocalDateTimeConverter INSTANCE = new LocalDateTimeConverter();

    private LocalDateTimeConverter() {
        super(15, QueryDataTypeFamily.TIMESTAMP);
    }

    @Override
    public Class<?> getValueClass() {
        return LocalDateTime.class;
    }

    @Override
    public String asVarchar(Object val) {
        return this.cast(val).toString();
    }

    @Override
    public LocalDate asDate(Object val) {
        return this.cast(val).toLocalDate();
    }

    @Override
    public LocalTime asTime(Object val) {
        return this.cast(val).toLocalTime();
    }

    @Override
    public LocalDateTime asTimestamp(Object val) {
        return this.cast(val);
    }

    @Override
    public OffsetDateTime asTimestampWithTimezone(Object val) {
        return LocalDateTimeConverter.timestampToTimestampWithTimezone(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asTimestamp(val);
    }

    private LocalDateTime cast(Object val) {
        return (LocalDateTime)val;
    }
}

