/*
 * Decompiled with CFR 0.152.
 */
package com.helger.maven.sch2xslt;

import com.google.common.annotations.VisibleForTesting;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.Since;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.error.IError;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.schematron.xslt.SCHTransformerCustomizer;
import com.helger.schematron.xslt.SchematronProviderXSLTFromSCH;
import com.helger.schematron.xslt.SchematronResourceSCHCache;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.AbstractTransformErrorListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.impl.StaticLoggerBinder;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"})
@Mojo(name="convert", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public final class Schematron2XSLTMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Component
    private MavenProject project;
    @Parameter(name="schematronDirectory", defaultValue="${basedir}/src/main/schematron", required=true)
    private File m_aSchematronDirectory;
    @Parameter(name="schematronPattern", defaultValue="**/*.sch", required=true)
    private String m_sSchematronPattern;
    @Parameter(name="xsltDirectory", defaultValue="${basedir}/src/main/xslt", required=true)
    private File m_aXsltDirectory;
    @Parameter(name="xsltExtension", defaultValue=".xslt", required=true)
    private String m_sXsltExtension;
    @Parameter(name="overwriteWithoutQuestion", defaultValue="true")
    private boolean m_bOverwriteWithoutNotice = true;
    @Parameter(name="phaseName")
    private String m_sPhaseName;
    @Parameter(name="languageCode")
    private String m_sLanguageCode;
    @Parameter(name="parameters")
    @Since(value="5.0.2")
    private Map<String, String> m_aCustomParameters;

    public void setSchematronDirectory(@Nonnull File file) {
        this.m_aSchematronDirectory = file;
        if (!this.m_aSchematronDirectory.isAbsolute()) {
            this.m_aSchematronDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        this.getLog().debug((CharSequence)("Searching Schematron files in the directory '" + this.m_aSchematronDirectory + "'"));
    }

    public void setSchematronPattern(@Nonnull String string) {
        this.m_sSchematronPattern = string;
        this.getLog().debug((CharSequence)("Setting Schematron pattern to '" + string + "'"));
    }

    public void setXsltDirectory(@Nonnull File file) {
        this.m_aXsltDirectory = file;
        if (!this.m_aXsltDirectory.isAbsolute()) {
            this.m_aXsltDirectory = new File(this.project.getBasedir(), file.getPath());
        }
        this.getLog().debug((CharSequence)("Writing XSLT files into directory '" + this.m_aXsltDirectory + "'"));
    }

    public void setXsltExtension(@Nonnull String string) {
        this.m_sXsltExtension = string;
        this.getLog().debug((CharSequence)("Setting XSLT file extension to '" + string + "'"));
    }

    public void setOverwriteWithoutQuestion(boolean bl) {
        this.m_bOverwriteWithoutNotice = bl;
        if (this.m_bOverwriteWithoutNotice) {
            this.getLog().debug((CharSequence)"Overwriting XSLT files without notice");
        } else {
            this.getLog().debug((CharSequence)"Ignoring existing Schematron files");
        }
    }

    public void setPhaseName(@Nullable String string) {
        this.m_sPhaseName = string;
        if (this.m_sPhaseName == null) {
            this.getLog().debug((CharSequence)"Using default phase");
        } else {
            this.getLog().debug((CharSequence)("Using the phase '" + this.m_sPhaseName + "'"));
        }
    }

    public void setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
        if (this.m_sLanguageCode == null) {
            this.getLog().debug((CharSequence)"Using default language code");
        } else {
            this.getLog().debug((CharSequence)("Using the language code '" + this.m_sLanguageCode + "'"));
        }
    }

    public void setParameters(@Nullable Map<String, String> map) {
        this.m_aCustomParameters = map;
        if (this.m_aCustomParameters == null || this.m_aCustomParameters.isEmpty()) {
            this.getLog().debug((CharSequence)"Using no custom parameters");
        } else {
            this.getLog().debug((CharSequence)("Using custom parameters " + this.m_aCustomParameters.toString()));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    @VisibleForTesting
    ICommonsMap<String, String> getParameters() {
        return new CommonsHashMap(this.m_aCustomParameters);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.m_aSchematronDirectory == null) {
            throw new MojoExecutionException("No Schematron directory specified!");
        }
        if (this.m_aSchematronDirectory.exists() && !this.m_aSchematronDirectory.isDirectory()) {
            throw new MojoExecutionException("The specified Schematron directory " + this.m_aSchematronDirectory + " is not a directory!");
        }
        if (StringHelper.hasNoText((String)this.m_sSchematronPattern)) {
            throw new MojoExecutionException("No Schematron pattern specified!");
        }
        if (this.m_aXsltDirectory == null) {
            throw new MojoExecutionException("No XSLT directory specified!");
        }
        if (this.m_aXsltDirectory.exists() && !this.m_aXsltDirectory.isDirectory()) {
            throw new MojoExecutionException("The specified XSLT directory " + this.m_aXsltDirectory + " is not a directory!");
        }
        if (StringHelper.hasNoText((String)this.m_sXsltExtension) || !this.m_sXsltExtension.startsWith(".")) {
            throw new MojoExecutionException("The XSLT extension '" + this.m_sXsltExtension + "' is invalid!");
        }
        if (!this.m_aXsltDirectory.exists() && !this.m_aXsltDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create the XSLT directory " + this.m_aXsltDirectory);
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this.m_aSchematronDirectory);
        directoryScanner.setIncludes(new String[]{this.m_sSchematronPattern});
        directoryScanner.setCaseSensitive(true);
        directoryScanner.scan();
        String[] stringArray = directoryScanner.getIncludedFiles();
        if (stringArray != null) {
            for (String string : stringArray) {
                String string2;
                Object object;
                File file = new File(this.m_aSchematronDirectory, string);
                File file2 = new File(this.m_aXsltDirectory, FilenameHelper.getWithoutExtension((String)string) + this.m_sXsltExtension);
                this.getLog().info((CharSequence)("Converting Schematron file '" + file.getPath() + "' to XSLT file '" + file2.getPath() + "'"));
                FileSystemResource fileSystemResource = new FileSystemResource(file);
                if (file2.exists() && !this.m_bOverwriteWithoutNotice) {
                    this.getLog().debug((CharSequence)("Skipping XSLT file '" + file2.getPath() + "' because it already exists!"));
                    continue;
                }
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.exists()) {
                    this.getLog().debug((CharSequence)("Creating directory '" + file3.getPath() + "'"));
                    if (!file3.mkdirs()) {
                        object = "Failed to convert '" + file.getPath() + "' because directory '" + file3.getPath() + "' could not be created";
                        this.getLog().error((CharSequence)object);
                        throw new MojoFailureException((String)object);
                    }
                }
                try {
                    FileOutputStream fileOutputStream;
                    XMLWriterSettings xMLWriterSettings;
                    Object object2;
                    this.buildContext.removeMessages(file);
                    object = new PluginErrorListener(file);
                    string2 = new SCHTransformerCustomizer().setErrorListener((ErrorListener)object).setPhase(this.m_sPhaseName).setLanguageCode(this.m_sLanguageCode).setParameters(this.m_aCustomParameters);
                    SchematronProviderXSLTFromSCH schematronProviderXSLTFromSCH = SchematronResourceSCHCache.createSchematronXSLTProvider((IReadableResource)fileSystemResource, (SCHTransformerCustomizer)string2);
                    if (schematronProviderXSLTFromSCH != null) {
                        object2 = new MapBasedNamespaceContext().addMapping("svrl", "http://purl.oclc.org/dsdl/svrl");
                        XMLHelper.forAllAttributes((Element)schematronProviderXSLTFromSCH.getXSLTDocument().getDocumentElement(), (arg_0, arg_1) -> Schematron2XSLTMojo.lambda$execute$0((MapBasedNamespaceContext)object2, arg_0, arg_1));
                        xMLWriterSettings = new XMLWriterSettings();
                        xMLWriterSettings.setNamespaceContext((INamespaceContext)object2).setPutNamespaceContextPrefixesInRoot(true);
                        fileOutputStream = FileHelper.getOutputStream((File)file2);
                        if (fileOutputStream == null) {
                            throw new IllegalStateException("Failed to open output stream for file " + file2.getAbsolutePath());
                        }
                    } else {
                        object2 = "Failed to convert '" + file.getPath() + "': the Schematron resource is invalid";
                        this.getLog().error((CharSequence)object2);
                        throw new MojoFailureException((String)object2);
                    }
                    XMLWriter.writeToStream((Node)schematronProviderXSLTFromSCH.getXSLTDocument(), (OutputStream)fileOutputStream, (IXMLWriterSettings)xMLWriterSettings);
                    this.getLog().debug((CharSequence)("Finished creating XSLT file '" + file2.getPath() + "'"));
                    this.buildContext.refresh(file3);
                }
                catch (MojoFailureException mojoFailureException) {
                    throw mojoFailureException;
                }
                catch (Exception exception) {
                    string2 = "Failed to convert '" + file.getPath() + "' to XSLT file '" + file2.getPath() + "'";
                    this.getLog().error((CharSequence)string2, (Throwable)exception);
                    throw new MojoExecutionException(string2, exception);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$execute$0(MapBasedNamespaceContext mapBasedNamespaceContext, String string, String string2) {
        if (string.startsWith("xmlns:")) {
            mapBasedNamespaceContext.addMapping(string.substring("xmlns:".length()), string2);
        }
    }

    public final class PluginErrorListener
    extends AbstractTransformErrorListener {
        private final File m_aSourceFile;

        public PluginErrorListener(File file) {
            this.m_aSourceFile = file;
        }

        protected void internalLog(@Nonnull IError iError) {
            int n = iError.getErrorLocation().getLineNumber();
            int n2 = iError.getErrorLocation().getColumnNumber();
            String string = StringHelper.getImplodedNonEmpty((String)" - ", (String[])new String[]{iError.getErrorText(Locale.US), iError.getLinkedExceptionMessage()});
            Schematron2XSLTMojo.this.buildContext.addMessage(this.m_aSourceFile, n <= 0 ? 0 : n, n2 <= 0 ? 0 : n2, string, iError.isError() ? 2 : 1, iError.getLinkedExceptionCause());
        }
    }
}

