/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.exception;

import com.heroku.api.exception.HerokuAPIException;
import com.heroku.api.http.HttpUtil;

public class RequestFailedException
extends HerokuAPIException {
    String responseBody;
    int statusCode;

    public RequestFailedException(String msg, int code, byte[] in) {
        this(msg, code, RequestFailedException.getBodyFromInput(in));
    }

    private static String getBodyFromInput(byte[] in) {
        try {
            return HttpUtil.getUTF8String(in);
        }
        catch (Exception e) {
            return "There was also an error reading the response body.";
        }
    }

    public RequestFailedException(String msg, int code, String body) {
        super(msg + " statuscode:" + code + " responseBody:" + body);
        this.responseBody = body;
        this.statusCode = code;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

