/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.domain;

import com.heroku.api.Domain;
import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DomainList
implements Request<List<Domain>> {
    private final RequestConfig config;

    public DomainList(String appName) {
        this(new RequestConfig().app(appName));
    }

    public DomainList(RequestConfig config) {
        this.config = config;
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Domains.format(this.config.getAppName());
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public List<Domain> getResponse(byte[] bytes, int status, Map<String, String> responseHeaders) {
        if (Http.Status.OK.equals(status)) {
            return (List)Json.parse(bytes, this.getClass());
        }
        throw new RequestFailedException("Unable to list domains.", status, bytes);
    }
}

