/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.log;

import com.heroku.api.Heroku;
import com.heroku.api.LogSession;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import com.heroku.api.request.log.LogStreamResponse;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class Log
implements Request<LogStreamResponse> {
    private final RequestConfig config;

    public Log(String app) {
        this(Log.logFor(app).getConfig());
    }

    public Log(String app, boolean tail) {
        this(Log.logFor(app).tail(tail).getConfig());
    }

    Log(RequestConfig config) {
        this.config = config;
    }

    public Log(LogRequestBuilder logRequest) {
        this(logRequest.getConfig());
    }

    public static LogRequestBuilder logFor(String app) {
        return new LogRequestBuilder().app(app);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.POST;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Logs.format(this.config.getAppName());
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public String getBody() {
        return this.config.asJson();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        return this.config.asMap();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public LogStreamResponse getResponse(byte[] bytes, int status, Map<String, String> responseHeaders) {
        if (Http.Status.CREATED.equals(status)) {
            try {
                LogSession logSession = (LogSession)Json.parse(bytes, LogSession.class);
                URL logs = HttpUtil.toURL(logSession.getLogplex_url());
                return new LogStreamResponse(logs);
            }
            catch (RuntimeException e) {
                throw new RequestFailedException(e.getMessage(), status, bytes);
            }
        }
        throw new RequestFailedException("Unable to get logs", status, bytes);
    }

    public static class LogRequestBuilder {
        RequestConfig config = new RequestConfig();

        public Log getRequest() {
            return new Log(this.config);
        }

        RequestConfig getConfig() {
            return this.config;
        }

        LogRequestBuilder add(Heroku.RequestKey key, String val) {
            this.config = this.config.with(key, val);
            return this;
        }

        public LogRequestBuilder app(String app) {
            this.config = this.config.app(app);
            return this;
        }

        public LogRequestBuilder num(int num) {
            return this.add(Heroku.RequestKey.LogLines, String.valueOf(num));
        }

        public LogRequestBuilder dyno(String dyno) {
            return this.add(Heroku.RequestKey.Dyno, dyno);
        }

        public LogRequestBuilder source(String source) {
            return this.add(Heroku.RequestKey.LogSource, source);
        }

        public LogRequestBuilder tail(boolean tail) {
            return tail ? this.add(Heroku.RequestKey.LogTail, "true") : this;
        }
    }
}

