/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer;

import com.ibm.aspera.faspmanager2.ITransferListener;
import com.ibm.cloud.objectstorage.event.ProgressListener;
import com.ibm.cloud.objectstorage.event.ProgressListenerChain;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaFaspManagerWrapper;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaResult;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaResultImpl;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransaction;
import com.ibm.cloud.objectstorage.services.aspera.transfer.AsperaTransferException;
import com.ibm.cloud.objectstorage.services.aspera.transfer.TransferListener;
import com.ibm.cloud.objectstorage.services.s3.transfer.TransferProgress;

public class AsperaTransactionImpl
implements AsperaTransaction {
    protected static final InternalLogApi log = InternalLogFactory.getLog(AsperaTransactionImpl.class);
    private final String xferid;
    private final TransferListener transferListener;
    private final AsperaFaspManagerWrapper asperaFaspManagerWrapper;
    private final String bucketName;
    private final String key;
    private final String fileName;
    AsperaResultImpl asperaResult;
    private static final String DONE = "DONE";
    private static final String ERROR = "ERROR";
    private static final String STOP = "STOP";
    private static final String ARGSTOP = "ARGSTOP";
    private static final String PROGRESS = "STATS";
    private static final String QUEUED = "INIT";
    private final TransferProgress transferProgress;
    protected final ProgressListenerChain listenerChain;

    public AsperaTransactionImpl(String xferid, String bucketName, String key, String fileName, TransferProgress transferProgress, ProgressListenerChain listenerChain) {
        this.xferid = xferid;
        this.transferListener = TransferListener.getInstance(xferid, this);
        this.bucketName = bucketName;
        this.key = key;
        this.fileName = fileName;
        this.transferProgress = transferProgress;
        this.listenerChain = listenerChain;
        this.asperaFaspManagerWrapper = new AsperaFaspManagerWrapper();
    }

    @Override
    public boolean pause() {
        return this.asperaFaspManagerWrapper.pause(this.xferid);
    }

    @Override
    public boolean resume() {
        return this.asperaFaspManagerWrapper.resume(this.xferid);
    }

    @Override
    public boolean cancel() {
        if (this.asperaFaspManagerWrapper.cancel(this.xferid)) {
            this.transferListener.removeAllTransactionSessions(this.xferid);
            return true;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.doesStatusMatch(DONE) || this.doesStatusMatch(ERROR) || this.doesStatusMatch(STOP) || this.doesStatusMatch(ARGSTOP);
    }

    @Override
    public boolean progress() {
        return this.doesStatusMatch(PROGRESS);
    }

    @Override
    public boolean onQueue() {
        return this.doesStatusMatch(QUEUED);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public AsperaResult waitForCompletion() throws AsperaTransferException, InterruptedException {
        while (!this.isDone() && this.asperaFaspManagerWrapper.isRunning(this.xferid)) {
            Thread.sleep(500L);
        }
        if (!this.doesStatusMatch(DONE)) {
            throw new AsperaTransferException("Aspera transfer has completed in Error");
        }
        this.asperaResult = new AsperaResultImpl(this.bucketName, this.key, this.fileName);
        return this.asperaResult;
    }

    private boolean doesStatusMatch(String status) {
        return status.equals(this.transferListener.getStatus(this.xferid));
    }

    @Override
    public void addProgressListener(ProgressListener listener) {
        this.listenerChain.addProgressListener(listener);
    }

    @Override
    public void removeProgressListener(ProgressListener listener) {
        this.listenerChain.removeProgressListener(listener);
    }

    public ProgressListenerChain getProgressListenerChain() {
        return this.listenerChain;
    }

    @Override
    public TransferProgress getProgress() {
        return this.transferProgress;
    }

    @Override
    public ITransferListener getTransferListener() {
        return this.transferListener;
    }

    protected void finalize() {
        this.transferListener.removeTransaction(this.xferid);
    }
}

