/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.watson.discovery.v1.model.CredentialDetails;
import com.ibm.watson.discovery.v1.model.StatusDetails;

public class Credentials
extends GenericModel {
    @SerializedName(value="credential_id")
    protected String credentialId;
    @SerializedName(value="source_type")
    protected String sourceType;
    @SerializedName(value="credential_details")
    protected CredentialDetails credentialDetails;
    protected StatusDetails status;

    protected Credentials() {
    }

    protected Credentials(Builder builder) {
        this.sourceType = builder.sourceType;
        this.credentialDetails = builder.credentialDetails;
        this.status = builder.status;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String credentialId() {
        return this.credentialId;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public CredentialDetails credentialDetails() {
        return this.credentialDetails;
    }

    public StatusDetails status() {
        return this.status;
    }

    public static class Builder {
        private String sourceType;
        private CredentialDetails credentialDetails;
        private StatusDetails status;

        private Builder(Credentials credentials) {
            this.sourceType = credentials.sourceType;
            this.credentialDetails = credentials.credentialDetails;
            this.status = credentials.status;
        }

        public Builder() {
        }

        public Credentials build() {
            return new Credentials(this);
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            return this;
        }

        public Builder status(StatusDetails status) {
            this.status = status;
            return this;
        }
    }

    public static interface SourceType {
        public static final String BOX = "box";
        public static final String SALESFORCE = "salesforce";
        public static final String SHAREPOINT = "sharepoint";
        public static final String WEB_CRAWL = "web_crawl";
        public static final String CLOUD_OBJECT_STORAGE = "cloud_object_storage";
    }
}

