/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class GetAutocompletionOptions
extends GenericModel {
    protected String projectId;
    protected String prefix;
    protected List<String> collectionIds;
    protected String field;
    protected Long count;

    protected GetAutocompletionOptions() {
    }

    protected GetAutocompletionOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notNull((Object)builder.prefix, (String)"prefix cannot be null");
        this.projectId = builder.projectId;
        this.prefix = builder.prefix;
        this.collectionIds = builder.collectionIds;
        this.field = builder.field;
        this.count = builder.count;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String prefix() {
        return this.prefix;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String field() {
        return this.field;
    }

    public Long count() {
        return this.count;
    }

    public static class Builder {
        private String projectId;
        private String prefix;
        private List<String> collectionIds;
        private String field;
        private Long count;

        private Builder(GetAutocompletionOptions getAutocompletionOptions) {
            this.projectId = getAutocompletionOptions.projectId;
            this.prefix = getAutocompletionOptions.prefix;
            this.collectionIds = getAutocompletionOptions.collectionIds;
            this.field = getAutocompletionOptions.field;
            this.count = getAutocompletionOptions.count;
        }

        public Builder() {
        }

        public Builder(String projectId, String prefix) {
            this.projectId = projectId;
            this.prefix = prefix;
        }

        public GetAutocompletionOptions build() {
            return new GetAutocompletionOptions(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull((Object)collectionIds, (String)"collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }
    }
}

