/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ListDocumentsOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected Long count;
    protected String status;
    protected Boolean hasNotices;
    protected Boolean isParent;
    protected String parentDocumentId;
    protected String sha256;

    protected ListDocumentsOptions() {
    }

    protected ListDocumentsOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.count = builder.count;
        this.status = builder.status;
        this.hasNotices = builder.hasNotices;
        this.isParent = builder.isParent;
        this.parentDocumentId = builder.parentDocumentId;
        this.sha256 = builder.sha256;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Long count() {
        return this.count;
    }

    public String status() {
        return this.status;
    }

    public Boolean hasNotices() {
        return this.hasNotices;
    }

    public Boolean isParent() {
        return this.isParent;
    }

    public String parentDocumentId() {
        return this.parentDocumentId;
    }

    public String sha256() {
        return this.sha256;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private Long count;
        private String status;
        private Boolean hasNotices;
        private Boolean isParent;
        private String parentDocumentId;
        private String sha256;

        private Builder(ListDocumentsOptions listDocumentsOptions) {
            this.projectId = listDocumentsOptions.projectId;
            this.collectionId = listDocumentsOptions.collectionId;
            this.count = listDocumentsOptions.count;
            this.status = listDocumentsOptions.status;
            this.hasNotices = listDocumentsOptions.hasNotices;
            this.isParent = listDocumentsOptions.isParent;
            this.parentDocumentId = listDocumentsOptions.parentDocumentId;
            this.sha256 = listDocumentsOptions.sha256;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
        }

        public ListDocumentsOptions build() {
            return new ListDocumentsOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder hasNotices(Boolean hasNotices) {
            this.hasNotices = hasNotices;
            return this;
        }

        public Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public Builder parentDocumentId(String parentDocumentId) {
            this.parentDocumentId = parentDocumentId;
            return this;
        }

        public Builder sha256(String sha256) {
            this.sha256 = sha256;
            return this;
        }
    }
}

